/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;

public class ProgressMonitoringReplacedElementFactory
implements ReplacedElementFactory {
    private static final String NEW_PAGE_ELEMENT = "div";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String NEW_PAGE_CLASS_VALUE = "pagetitle";
    private final ReplacedElementFactory factory;
    private final PdfExportProgressMonitor progressMonitor;
    private String lastPageEncountered = null;

    public ProgressMonitoringReplacedElementFactory(ReplacedElementFactory factory, PdfExportProgressMonitor progressMonitor) {
        this.factory = factory;
        this.progressMonitor = progressMonitor;
    }

    public ReplacedElement createReplacedElement(LayoutContext layoutcontext, BlockBox blockbox, UserAgentCallback useragentcallback, int i, int j) {
        Element element = blockbox.getElement();
        if (NEW_PAGE_ELEMENT.equals(element.getNodeName()) && NEW_PAGE_CLASS_VALUE.equals(element.getAttribute(CLASS_ATTRIBUTE_NAME))) {
            String pageTitle = this.getPageTitle(element);
            this.lastPageEncountered = pageTitle != null ? pageTitle : "no title found";
            this.progressMonitor.performingHtmlToPdfConversionForPage(pageTitle);
        }
        return this.factory.createReplacedElement(layoutcontext, blockbox, useragentcallback, i, j);
    }

    private String getPageTitle(Element element) {
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() < 2) {
            return null;
        }
        return childNodes.item(1).getTextContent();
    }

    public void setFormSubmissionListener(FormSubmissionListener listener) {
    }

    public void remove(Element element) {
        this.factory.remove(element);
    }

    public void reset() {
        this.factory.reset();
    }

    public String getLastPageTitle() {
        return this.lastPageEncountered;
    }
}

