/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.ProgressMeterWrappingProgressMonitor;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.core.task.longrunning.AbstractLongRunningTask;
import com.atlassian.user.User;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfExportLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private PlatformTransactionManager transactionManager;
    private I18NBean i18NBean;
    private ImportExportManager importExportManager;
    private PdfExporterService flyingPdfExporterService;
    private GateKeeper gateKeeper;
    private final List<String> contentToBeExported;
    private final Space space;
    private final User remoteUser;
    private final String contextPath;
    private String downloadPath;

    public PdfExportLongRunningTask(List<String> contentToBeExported, Space space, User remoteUser, String contextPath) {
        this.contentToBeExported = contentToBeExported;
        this.space = space;
        this.remoteUser = remoteUser;
        this.contextPath = contextPath;
    }

    protected void runInternal() {
        TransactionTemplate tt = new TransactionTemplate();
        tt.setTransactionManager(this.transactionManager);
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AuthenticatedUserThreadLocal.setUser((User)PdfExportLongRunningTask.this.remoteUser);
                RequestCacheThreadLocal.setRequestCache(new HashMap());
                ProgressMeterWrappingProgressMonitor monitor = new ProgressMeterWrappingProgressMonitor(PdfExportLongRunningTask.this.i18NBean, PdfExportLongRunningTask.this.progress);
                try {
                    ContentTree contentTree = PdfExportLongRunningTask.this.importExportManager.getContentTree(PdfExportLongRunningTask.this.remoteUser, PdfExportLongRunningTask.this.space);
                    contentTree.filter(PdfExportLongRunningTask.this.contentToBeExported);
                    File pdfFile = PdfExportLongRunningTask.this.flyingPdfExporterService.createPdfForSpace(PdfExportLongRunningTask.this.remoteUser, PdfExportLongRunningTask.this.space, contentTree, monitor, PdfExportLongRunningTask.this.contextPath);
                    PdfExportLongRunningTask.this.downloadPath = PdfExportLongRunningTask.this.importExportManager.prepareDownloadPath(pdfFile.getAbsolutePath());
                    PdfExportLongRunningTask.this.gateKeeper.addKey(PdfExportLongRunningTask.this.downloadPath, PdfExportLongRunningTask.this.remoteUser);
                    PdfExportLongRunningTask.this.downloadPath = PdfExportLongRunningTask.this.contextPath + PdfExportLongRunningTask.this.downloadPath;
                    monitor.completed(PdfExportLongRunningTask.this.downloadPath);
                }
                catch (Exception ex) {
                    AbstractLongRunningTask.log.error((Object)"Error during PDF export", (Throwable)ex);
                    String exceptionMessage = ex.getMessage();
                    if (StringUtils.isBlank((String)exceptionMessage)) {
                        exceptionMessage = ex.getClass().getName();
                    }
                    monitor.errored(exceptionMessage);
                }
            }
        });
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public String getName() {
        return "PDF Space Export";
    }

    public String getNameKey() {
        return "com.atlassian.confluence.extra.flyingpdf.exporttaskname";
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setI18NBean(I18NBean bean) {
        this.i18NBean = bean;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setFlyingPdfExporterService(PdfExporterService flyingPdfExporterService) {
        this.flyingPdfExporterService = flyingPdfExporterService;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }
}

