/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.extra.flyingpdf.PdfExportLongRunningTask;
import com.atlassian.confluence.extra.flyingpdf.PdfExportLongRunningTaskFactory;
import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.longrunning.LongRunningTaskUtils;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetterExportSpaceAction
extends AbstractSpaceAction
implements ServletRequestAware {
    private HttpServletRequest servletRequest;
    private PdfExportLongRunningTaskFactory pdfExportLongRunningTaskFactory;
    private String downloadPath;
    private List<String> contentToBeExported;
    private ServletContext servletContext;
    private PdfExporterService flyingPdfExporterService;
    private PermissionManager permissionManager;
    private ContentTree contentTree;

    public String doExport() throws Exception {
        PdfExportLongRunningTask task = this.pdfExportLongRunningTaskFactory.createNewLongRunningTask(this.getI18n(), this.getContentToBeExported(), this.getSpace(), this.getRemoteUser(), this.servletRequest.getContextPath());
        if (this.isLongRunningTaskSupported()) {
            this.startTask(task);
            return "success";
        }
        task.run();
        this.downloadPath = task.getDownloadPath();
        return "download";
    }

    protected void startTask(PdfExportLongRunningTask task) {
        LongRunningTaskUtils.startTask((LongRunningTask)task);
    }

    public String execute() throws Exception {
        return this.doExport();
    }

    public ContentTree getContentTree() {
        if (this.contentTree == null) {
            this.contentTree = this.flyingPdfExporterService.getContentTree(this.getRemoteUser(), this.getSpace());
        }
        return this.contentTree;
    }

    public boolean isPermitted() {
        return this.flyingPdfExporterService.isPermitted(this.getRemoteUser(), this.getSpace());
    }

    private boolean isLongRunningTaskSupported() {
        String runningServer = this.getServletContext().getServerInfo().toLowerCase();
        String unsupportedContainers = this.getServletContext().getInitParameter("unsupportedContainersForExportLongRunningTask");
        if (TextUtils.stringSet((String)unsupportedContainers)) {
            String[] containers = unsupportedContainers.split(",");
            for (int i = 0; i < containers.length; ++i) {
                String container = containers[i];
                if (runningServer.indexOf(container = StringUtils.trim((String)container)) == -1) continue;
                return false;
            }
        }
        return true;
    }

    public String getSpaceAdvancedUrl() {
        return "/spaces/viewspacesummary.action?key=" + this.getHelper().getSpaceKey();
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public List<String> getContentToBeExported() {
        return this.contentToBeExported;
    }

    public void setContentToBeExported(List<String> contentToBeExported) {
        this.contentToBeExported = contentToBeExported;
    }

    public boolean isSpaceAdmin() {
        if (GeneralUtil.isSuperUser((User)this.getRemoteUser())) {
            return true;
        }
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, (Object)this.getSpace());
    }

    public ServletContext getServletContext() {
        if (this.servletContext != null) {
            return this.servletContext;
        }
        return ServletActionContext.getServletContext();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setPdfExportLongRunningTaskFactory(PdfExportLongRunningTaskFactory pdfExportLongRunningTaskFactory) {
        this.pdfExportLongRunningTaskFactory = pdfExportLongRunningTaskFactory;
    }

    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void setFlyingPdfExporterService(PdfExporterService flyingPdfExporterService) {
        this.flyingPdfExporterService = flyingPdfExporterService;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

