/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.rest.api.model.RestList;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.std.SerializerBase;

public class PageResponseSerializer
extends SerializerBase<PageResponse<?>> {
    public PageResponseSerializer() {
        super(PageResponse.class, false);
    }

    public void serialize(PageResponse<?> value, JsonGenerator jsonGen, SerializerProvider provider) throws IOException {
        jsonGen.writeStartObject();
        jsonGen.writeArrayFieldStart("results");
        for (Object result : value.getResults()) {
            jsonGen.writeObject(result);
        }
        jsonGen.writeEndArray();
        PageRequest pageRequest = value.getPageRequest();
        if (pageRequest != null) {
            jsonGen.writeObjectField("start", (Object)pageRequest.getStart());
            jsonGen.writeObjectField("limit", (Object)pageRequest.getLimit());
        }
        jsonGen.writeObjectField("size", (Object)value.getResults().size());
        if (value instanceof RestList) {
            RestList restList = (RestList)value;
            for (Map.Entry prop : restList.getProperties().entrySet()) {
                jsonGen.writeFieldName((String)prop.getKey());
                jsonGen.writeObject(prop.getValue());
            }
        }
        jsonGen.writeEndObject();
        jsonGen.flush();
    }
}

