/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@ExperimentalApi
public class ExpansionsParser {
    public static Expansion[] parse(String expand) {
        if (StringUtils.isBlank((String)expand)) {
            return new Expansion[0];
        }
        return ExpansionsParser.parse(expand.split(",")).toArray();
    }

    public static Expansions parseAsExpansions(String expand) {
        return new Expansions(ExpansionsParser.parse(expand));
    }

    public static Expansion parseSingle(String expand) {
        return ExpansionsParser.parse(expand)[0];
    }

    public static String asString(Expansions expansions) {
        if (expansions == null) {
            return null;
        }
        return ExpansionsParser.asString(expansions.toArray());
    }

    public static String asString(Expansion[] expansionsArr) {
        ArrayList parents = Lists.newArrayList();
        return ExpansionsParser.asString((List<String>)parents, expansionsArr);
    }

    private static String asString(List<String> parents, Expansion[] expansionsArr) {
        if (expansionsArr.length == 0) {
            return null;
        }
        ArrayList expansionStrings = Lists.newArrayList();
        for (Expansion expansion : expansionsArr) {
            expansionStrings.add(ExpansionsParser.asString(parents, expansion));
        }
        Collections.sort(expansionStrings);
        return StringUtils.join((Collection)expansionStrings, (String)",");
    }

    private static String asString(List<String> parents, Expansion expansion) {
        String propertyName = expansion.getPropertyName();
        Expansions subExpansions = expansion.getSubExpansions();
        ArrayList pathParts = Lists.newArrayList();
        pathParts.addAll(parents);
        pathParts.add(propertyName);
        if (subExpansions.toArray().length == 0) {
            return StringUtils.join((Collection)pathParts, (String)".");
        }
        return ExpansionsParser.asString((List<String>)pathParts, subExpansions.toArray());
    }

    public static Expansions parse(String ... individualExpansions) {
        ArrayList<Expansion> expandyBits = new ArrayList<Expansion>();
        for (String individualExpansion : individualExpansions) {
            expandyBits.add(ExpansionsParser.toExpansion(individualExpansion));
        }
        return new Expansions(expandyBits);
    }

    public static Expansions parseWithPrefix(String prefix, String expansions) {
        Expansion[] subExpansions = ExpansionsParser.parse(expansions);
        return new Expansions(new Expansion[]{new Expansion(prefix, new Expansions(subExpansions))});
    }

    private static Expansion toExpansion(String individualExpansion) {
        String[] pathParts = individualExpansion.split("\\.");
        return ExpansionsParser.toExpansion(pathParts);
    }

    private static Expansion toExpansion(String[] pathDotParts) {
        String pathStart = pathDotParts[0];
        if (pathDotParts.length == 1) {
            return new Expansion(pathStart);
        }
        return new Expansion(pathStart, new Expansions(new Expansion[]{ExpansionsParser.toExpansion(ExpansionsParser.rest(pathDotParts))}));
    }

    private static String[] rest(String[] pathParts) {
        return Arrays.copyOfRange(pathParts, 1, pathParts.length);
    }
}

