/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.ContentTooLongException;
import com.atlassian.confluence.api.service.exceptions.InternalServerException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.api.model.RestError;
import com.atlassian.confluence.rest.api.model.validation.RestValidationResult;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalApi
public class ExceptionConverter {
    private static final Logger log = LoggerFactory.getLogger(ExceptionConverter.class);
    public static final Response.StatusType NOT_IMPLEMENTED = new Response.StatusType(){

        public int getStatusCode() {
            return 501;
        }

        public Response.Status.Family getFamily() {
            return Response.Status.Family.SERVER_ERROR;
        }

        public String getReasonPhrase() {
            return "Not Implemented";
        }
    };

    public static enum AdditionalStatus implements Response.StatusType
    {
        REQUEST_TOO_LONG(413, "Request Entity Too Large", Response.Status.Family.CLIENT_ERROR);

        private final int code;
        private final String reason;
        private Response.Status.Family family;

        private AdditionalStatus(int statusCode, String reasonPhrase, Response.Status.Family family) {
            this.code = statusCode;
            this.reason = reasonPhrase;
            this.family = family;
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public int getStatusCode() {
            return this.code;
        }

        public String getReasonPhrase() {
            return this.toString();
        }

        public String toString() {
            return this.reason;
        }
    }

    public static class Server {
        public static RestError convertServiceException(Exception e) {
            Response.StatusType type = Server.getStatusTypeForException(e);
            RestValidationResult validationResult = Server.getValidationResultForException(e);
            if (type != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Logging converted API exception: ", (Throwable)e);
                } else if (type == Response.Status.INTERNAL_SERVER_ERROR) {
                    log.error("Converted internal server error: ", (Throwable)e);
                }
                return new RestError(type, e.getMessage(), validationResult);
            }
            log.error("No status code found for exception, converting to internal server error : ", (Throwable)e);
            return new RestError((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, e.getClass().getName() + ": " + e.getMessage(), validationResult);
        }

        @Nullable
        private static RestValidationResult getValidationResultForException(Exception e) {
            if (e instanceof ServiceException) {
                return new RestValidationResult((ValidationResult)((ServiceException)e).getOptionalValidationResult().getOrNull());
            }
            return null;
        }

        @Nullable
        private static Response.StatusType getStatusTypeForException(Exception e) {
            if (e instanceof NotFoundException) {
                return Response.Status.NOT_FOUND;
            }
            if (e instanceof PermissionException) {
                return Response.Status.FORBIDDEN;
            }
            if (e instanceof BadRequestException || e instanceof JsonMappingException) {
                return Response.Status.BAD_REQUEST;
            }
            if (e instanceof ContentTooLongException) {
                return AdditionalStatus.REQUEST_TOO_LONG;
            }
            if (e instanceof UnsupportedOperationException || e instanceof NotImplementedServiceException) {
                return NOT_IMPLEMENTED;
            }
            if (e instanceof ConflictException) {
                return Response.Status.CONFLICT;
            }
            if (e instanceof InternalServerException) {
                return Response.Status.INTERNAL_SERVER_ERROR;
            }
            return null;
        }
    }

    public static class Client {
        public static ServiceException convertToServiceException(UniformInterfaceException e) {
            try {
                int status;
                ClientResponse response = e.getResponse();
                String message = "";
                ValidationResult validationResult = null;
                MediaType responseType = response.getType();
                if (responseType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                    RestError error = (RestError)response.getEntity(RestError.class);
                    status = error.getStatusCode();
                    message = error.getMessage();
                    validationResult = error.getData();
                } else {
                    status = response.getStatus();
                    if (responseType.equals((Object)MediaType.TEXT_PLAIN_TYPE) || responseType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                        message = (String)response.getEntity(String.class);
                    }
                }
                switch (status) {
                    case 400: 
                    case 413: {
                        return validationResult != null ? new BadRequestException(message, validationResult) : new BadRequestException(message, (Throwable)e);
                    }
                    case 403: {
                        return validationResult != null ? new PermissionException(message, validationResult) : new PermissionException(message, (Throwable)e);
                    }
                    case 404: {
                        return validationResult != null ? new NotFoundException(message, validationResult) : new NotFoundException(message, (Throwable)e);
                    }
                    case 409: {
                        return validationResult != null ? new ConflictException(message, validationResult) : new ConflictException(message, (Throwable)e);
                    }
                    case 500: {
                        return validationResult != null ? new InternalServerException(message, validationResult) : new InternalServerException(message, (Throwable)e);
                    }
                    case 501: {
                        return validationResult != null ? new NotImplementedServiceException(message, validationResult) : new NotImplementedServiceException(message, (Exception)e);
                    }
                }
                return validationResult != null ? new ServiceException(message, validationResult) : new ServiceException(message, (Throwable)e);
            }
            catch (ClientHandlerException ex) {
                log.error("Could not convert RestError due to :" + ex.getMessage() + "\n Response entity from original exception : " + e.getResponse() + ", throwing original exception\nError Entity: " + (String)e.getResponse().getEntity(String.class));
                throw e;
            }
        }
    }
}

