/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.permissions.Operation;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.TargetType;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class OperationDescription
implements Operation {
    @JsonProperty
    private final TargetType targetType;
    @JsonProperty
    private final OperationKey operationKey;

    private OperationDescription(OperationDescriptionBuilder builder) {
        Preconditions.checkNotNull((Object)builder.targetType, (Object)"targetType must not be null");
        Preconditions.checkNotNull((Object)builder.operationKey, (Object)"operationKey must not be null");
        this.targetType = builder.targetType;
        this.operationKey = builder.operationKey;
    }

    public static OperationDescriptionBuilder builder() {
        return new OperationDescriptionBuilder();
    }

    @Override
    @Nonnull
    public OperationKey getOperationKey() {
        return this.operationKey;
    }

    @Nonnull
    public TargetType getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("targetType", (Object)this.getTargetType()).add("operationKey", (Object)this.getOperationKey()).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationDescription that = (OperationDescription)o;
        return this.targetType.equals(that.targetType) && this.operationKey.equals(that.operationKey);
    }

    public int hashCode() {
        return Objects.hash(this.targetType, this.operationKey);
    }

    public static class OperationDescriptionBuilder {
        private TargetType targetType;
        private OperationKey operationKey;

        public OperationDescription build() {
            return new OperationDescription(this);
        }

        public OperationDescriptionBuilder targetType(@Nonnull TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public OperationDescriptionBuilder operationKey(@Nonnull OperationKey operationKey) {
            this.operationKey = operationKey;
            return this;
        }
    }
}

