/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.longtasks;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonValue;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class LongTaskId {
    private final UUID uuid;

    private LongTaskId(UUID uuid) {
        this.uuid = uuid;
    }

    @JsonCreator
    public static LongTaskId deserialise(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            throw new BadRequestException("LongTaskId string must not be null or empty: " + id);
        }
        return new LongTaskId(UUID.fromString(id));
    }

    @JsonValue
    public String serialise() {
        return String.valueOf(this.uuid);
    }

    public boolean equals(Object other) {
        if (other instanceof LongTaskId) {
            return Objects.equal((Object)this.uuid, (Object)((LongTaskId)other).uuid);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uuid});
    }
}

