/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content.id;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.AttachmentContentId;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.google.common.base.Objects;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonValue;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentId
implements Comparable {
    public static final ContentId UNSET = new ContentId(0L);
    private Long id;

    ContentId(long id) {
        this.id = id;
    }

    @JsonCreator
    public static ContentId deserialise(@JsonProperty(value="id") String id) throws BadRequestException {
        if (id == null || id.isEmpty()) {
            throw new BadRequestException("ContentId string must not be null or empty: " + id);
        }
        try {
            return new ContentId(Long.parseLong(id));
        }
        catch (NumberFormatException numberFormatException) {
            if (AttachmentContentId.handles(id)) {
                return new AttachmentContentId(id);
            }
            throw new BadRequestException("Can't parse as a ContentId: " + id);
        }
    }

    public static ContentId of(ContentType type, long id) {
        if (type == ContentType.ATTACHMENT) {
            return new AttachmentContentId(id);
        }
        return new ContentId(id);
    }

    @JsonValue
    public String serialise() {
        return String.valueOf(this.id);
    }

    public long asLong() {
        return this.id;
    }

    public boolean isSet() {
        return this.id > 0L;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (ContentId.class.equals(other.getClass())) {
            return Objects.equal((Object)this.id, (Object)((ContentId)other).id);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.serialise()).toString();
    }

    public static ContentId valueOf(String id) throws BadRequestException {
        return ContentId.deserialise(id);
    }

    public int compareTo(Object o) {
        if (o instanceof ContentId) {
            ContentId other = (ContentId)o;
            if (this.id.equals(other.id)) {
                return 0;
            }
            if (this.id < other.id) {
                return -1;
            }
        }
        return 1;
    }
}

