/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content.id;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.google.common.base.Objects;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
@Internal
public class AttachmentContentId
extends ContentId {
    private static final String PREFIX = "att";

    static boolean handles(String id) {
        return id.startsWith(PREFIX);
    }

    AttachmentContentId(String id) {
        this(Long.parseLong(id.substring(PREFIX.length())));
    }

    AttachmentContentId(long id) {
        super(id);
    }

    @Override
    public String serialise() {
        return PREFIX + this.asLong();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AttachmentContentId) {
            return this.asLong() == ((AttachmentContentId)other).asLong();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{PREFIX, this.asLong()});
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof AttachmentContentId) {
            ContentId other = (ContentId)o;
            if (this.asLong() == other.asLong()) {
                return 0;
            }
            if (this.asLong() < other.asLong()) {
                return -1;
            }
        }
        return 1;
    }
}

