/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.FormattedBody;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@ExperimentalApi
@RestEnrichable
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentBody
extends FormattedBody {
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Content.class)
    @JsonProperty
    private final Reference<Content> content;

    public ContentBody(ContentRepresentation representation, String value, Reference<Content> contentReference) {
        super(representation, value);
        this.content = contentReference;
    }

    public ContentBody(ContentRepresentation representation, String value, ContentId contentId) {
        this(representation, value, Content.buildReference(contentId));
    }

    public ContentBody(ContentRepresentation representation, String value, Content content) {
        this(representation, value, Reference.to(content));
    }

    @JsonCreator
    public ContentBody(@JsonProperty(value="representation") ContentRepresentation representation, @JsonProperty(value="value") String value) {
        this(representation, value, Reference.empty(Content.class));
    }

    public static ContentBody emptyBody(ContentRepresentation representation, Reference<Content> contentReference) {
        return new ContentBody(representation, null, contentReference);
    }

    public Reference<Content> getContentRef() {
        if (this.content == null) {
            return Reference.empty(Content.class);
        }
        return this.content;
    }

    public boolean hasExpandedContentRef() {
        Reference<Content> contentRef = this.getContentRef();
        return contentRef.exists() && contentRef.isExpanded();
    }
}

