/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Expansions;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;

@ExperimentalApi
public class Expansion {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private final String propertyName;
    private final Expansions subExpansions;
    public static final Function<String, Expansion> AS_EXPANSION = Expansion::new;

    public Expansion(String propertyName) {
        this(propertyName, Expansions.EMPTY);
    }

    public Expansion(String propertyName, Expansions subExpansions) {
        this.propertyName = propertyName;
        this.subExpansions = subExpansions;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Expansions getSubExpansions() {
        return this.subExpansions;
    }

    public static Expansion combine(Object ... expansionParts) {
        return new Expansion(DOT_JOINER.join(expansionParts));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.propertyName).add("subExpansions", (Object)this.subExpansions).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expansion expansion = (Expansion)o;
        if (this.propertyName != null ? !this.propertyName.equals(expansion.propertyName) : expansion.propertyName != null) {
            return false;
        }
        return !(this.subExpansions != null ? !this.subExpansions.equals(expansion.subExpansions) : expansion.subExpansions != null);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.propertyName, this.subExpansions});
    }
}

