/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.relations;

import com.atlassian.confluence.api.model.relations.AbstractRelationDescriptor;
import com.atlassian.confluence.api.model.relations.FavouriteRelationDescriptor;
import com.atlassian.confluence.api.model.relations.LikeRelationDescriptor;
import com.atlassian.confluence.api.model.relations.NamedRelationDescriptor;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

public final class RelationDescriptors {
    private static ImmutableMultimap<String, RelationDescriptor> relationDescriptorsByName = ImmutableMultimap.of();

    static synchronized void registerBuiltIn(RelationDescriptor ... relationDescriptors) {
        Preconditions.checkNotNull((Object)relationDescriptors, (Object)"relationDescriptors");
        ArrayListMultimap newRelationDescriptorsByName = ArrayListMultimap.create(relationDescriptorsByName);
        for (RelationDescriptor relationDescriptor : relationDescriptors) {
            newRelationDescriptorsByName.put((Object)relationDescriptor.getRelationName().toLowerCase(Locale.ENGLISH), (Object)relationDescriptor);
        }
        relationDescriptorsByName = ImmutableMultimap.copyOf((Multimap)newRelationDescriptorsByName);
    }

    public static <S extends Relatable, T extends Relatable> RelationDescriptor<S, T> lookupBuiltinOrCreate(Class<S> sourceClass, String name, Class<T> targetClass) {
        Preconditions.checkNotNull(sourceClass, (Object)"sourceClass");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(targetClass, (Object)"targetClass");
        ImmutableCollection descriptors = relationDescriptorsByName.get((Object)name.toLowerCase(Locale.ENGLISH));
        if (descriptors.isEmpty()) {
            return new NamedRelationDescriptor<S, T>(name, sourceClass, targetClass);
        }
        for (RelationDescriptor descriptor : descriptors) {
            if (!sourceClass.isAssignableFrom(descriptor.getSourceClass()) || !targetClass.isAssignableFrom(descriptor.getTargetClass())) continue;
            return descriptor;
        }
        return new AbstractRelationDescriptor<S, T>(name, sourceClass, targetClass, (Collection)descriptors, name){
            final /* synthetic */ Collection val$descriptors;
            final /* synthetic */ String val$name;
            {
                this.val$descriptors = collection;
                this.val$name = string;
                super(relationName, sourceClass, targetClass);
            }

            @Override
            public ValidationResult canRelate(S source, T target) {
                return RelationDescriptors.reportInvalidSourceOrTargetType(this.val$descriptors, this.val$name, source, target);
            }
        };
    }

    private static <S extends Relatable, T extends Relatable> ValidationResult reportInvalidSourceOrTargetType(Collection<RelationDescriptor> descriptors, String name, S source, T target) {
        if (!descriptors.stream().anyMatch(x -> x.getSourceClass().isInstance(source))) {
            String validSourceTypes = String.join((CharSequence)", ", descriptors.stream().map(x -> x.getSourceClass().getSimpleName()).distinct().collect(Collectors.toList()));
            return RelationDescriptors.createError(String.format("Source of a %s relation must be of type %s", name, validSourceTypes));
        }
        if (!descriptors.stream().anyMatch(x -> x.getTargetClass().isInstance(target))) {
            String validTargetTypes = String.join((CharSequence)", ", descriptors.stream().map(x -> x.getTargetClass().getSimpleName()).distinct().collect(Collectors.toList()));
            return RelationDescriptors.createError(String.format("Target of a %s relation must be of type %s", name, validTargetTypes));
        }
        throw new IllegalStateException("Source and target types are valid");
    }

    public static <S extends Relatable, T extends Relatable> ValidationResult canRelate(S source, RelationDescriptor<S, T> relationDescriptor, T target) {
        if (!relationDescriptor.getSourceClass().isInstance(source)) {
            return RelationDescriptors.createError(String.format("The source of a '%s' relation must be a %s", relationDescriptor.getRelationName(), relationDescriptor.getSourceClass().getSimpleName()));
        }
        if (!relationDescriptor.getTargetClass().isInstance(target)) {
            return RelationDescriptors.createError(String.format("The target of a '%s' relation must be a %s", relationDescriptor.getRelationName(), relationDescriptor.getTargetClass().getSimpleName()));
        }
        return relationDescriptor.canRelate(source, target);
    }

    private static ValidationResult createError(String error) {
        SimpleValidationResult.Builder resultBuilder = SimpleValidationResult.builder().authorized(true);
        resultBuilder.addError(error, new Object[0]);
        return resultBuilder.build();
    }

    static {
        FavouriteRelationDescriptor.register();
        LikeRelationDescriptor.register();
    }
}

