package com.atlassian.confluence.compat.struts2.actioncontext;

import com.atlassian.confluence.api.service.exceptions.ServiceException;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;

class ActionContextStruts2AndWWCompat implements ActionContextCompat {

    public static final String STRUTS_ACTION_CONTEXT = "com.opensymphony.xwork2.ActionContext";
    public static final String STRUTS_HTTP_PARAMETERS = "org.apache.struts2.dispatcher.HttpParameters";
    public static final String STRUTS_HTTP_PARAMETERS_BUILDER = "org.apache.struts2.dispatcher.HttpParameters$Builder";
    private final Method getContext;
    private final Method setApplication;
    private final Method getApplication;
    private final Method setContextMap;
    private final Method getContextMap;
    private final Method setConversionErrors;
    private final Method getConversionErrors;
    private final Method setLocale;
    private final Method getLocale;
    private final Method setName;
    private final Method getName;
    private final Method setParameters;
    private final Method getParameters;
    private final Method setSession;
    private final Method getSession;
    private final Method get;
    private final Method put;
    private final Object context;
    private ClassLoader classLoader;
    private static String actionContextClass;

    ActionContextStruts2AndWWCompat(String actionContextClass, ClassLoader classLoader) throws ReflectiveOperationException {
        this.actionContextClass = actionContextClass;
        this.classLoader = classLoader;
        getContext = getACStruts2Method("getContext", classLoader);
        setApplication = getACStruts2Method("setApplication", classLoader, Map.class);
        getApplication = getACStruts2Method("getApplication", classLoader);
        setContextMap = getACStruts2Method("setContextMap", classLoader, Map.class);
        getContextMap = getACStruts2Method("getContextMap", classLoader);
        setConversionErrors = getACStruts2Method("setConversionErrors", classLoader, Map.class);
        getConversionErrors = getACStruts2Method("getConversionErrors", classLoader);
        setLocale = getACStruts2Method("setLocale", classLoader, Locale.class);
        getLocale = getACStruts2Method("getLocale", classLoader);
        setName = getACStruts2Method("setName", classLoader, String.class);
        getName = getACStruts2Method("getName", classLoader);
        if (STRUTS_ACTION_CONTEXT.equals(actionContextClass)) {
            setParameters = getACStruts2Method("setParameters", classLoader, Class.forName(STRUTS_HTTP_PARAMETERS));
        } else {
            setParameters = getACStruts2Method("setParameters", classLoader, Map.class);
        }
        getParameters = getACStruts2Method("getParameters", classLoader);
        setSession = getACStruts2Method("setSession", classLoader, Map.class);
        getSession = getACStruts2Method("getSession", classLoader);
        get = getACStruts2Method("get", classLoader, Object.class);
        put = getACStruts2Method("put", classLoader, Object.class, Object.class);
        context = getContext.invoke(null);
    }

    @Override
    public void setApplication(Map application) {
        try {
            setApplication.invoke(Class.forName(this.actionContextClass).cast(context), application);
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext application", e);
        }
    }

    @Override
    public Map getApplication() {
        try {
            return (Map) getApplication.invoke(Class.forName(this.actionContextClass).cast(context));
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext application", e);
        }
    }

    @Override
    public void setContextMap(Map contextMap) {
        try {
            setContextMap.invoke(Class.forName(this.actionContextClass).cast(context), contextMap);
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext contextmap", e);
        }
    }

    @Override
    public Map getContextMap() {
        try {
            return (Map) getContextMap.invoke(Class.forName(this.actionContextClass).cast(context));
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext contextmap", e);
        }
    }

    @Override
    public void setConversionErrors(Map conversionErrors) {
        try {
            setConversionErrors.invoke(Class.forName(this.actionContextClass).cast(context), conversionErrors);
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext conversionerrors", e);
        }
    }

    @Override
    public Map getConversionErrors() {
        try {
            return (Map) getConversionErrors.invoke(Class.forName(this.actionContextClass).cast(context));
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext conversionerrors", e);
        }
    }

    @Override
    public void setLocale(Locale locale) {
        try {
            setLocale.invoke(Class.forName(this.actionContextClass).cast(context), locale);
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext locale", e);
        }
    }

    @Override
    public Locale getLocale() {
        try {
            return (Locale) getLocale.invoke(Class.forName(this.actionContextClass).cast(context));
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext locale", e);
        }
    }

    @Override
    public void setName(String name) {
        try {
            setName.invoke(Class.forName(this.actionContextClass).cast(context), name);
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext name", e);
        }
    }

    @Override
    public String getName() {
        try {
            return (String) getName.invoke(Class.forName(this.actionContextClass).cast(context));
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext name", e);
        }
    }
    /**
     * This method will convert map to HttpParameters type to provide backward compatibility
     */
    @Override
    public void setParameters(Map parameters) {
        try {
            if (STRUTS_ACTION_CONTEXT.equals(actionContextClass)) {
                Method createMethod = Class.forName(STRUTS_HTTP_PARAMETERS, false, classLoader)
                        .getMethod("create", Map.class);
                Object obj = createMethod.invoke(null, parameters);
                Method buildMethod = Class.forName(STRUTS_HTTP_PARAMETERS_BUILDER, false, classLoader)
                        .getMethod("build");
                Object httpParametersMap = buildMethod.invoke(Class.forName(STRUTS_HTTP_PARAMETERS_BUILDER).cast(obj));
                setParameters.invoke(Class.forName(this.actionContextClass).cast(context), Class.forName(STRUTS_HTTP_PARAMETERS).cast(httpParametersMap));
            } else {
                setParameters.invoke(Class.forName(this.actionContextClass).cast(context), parameters);
            }
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext parameter", e);
        }
    }

    /**
     * This method will convert the HttpParameters object to map of Map<String, String[]> and return the same to provide backward compatibility
     */
    @Override
    public Map getParameters() {
        try {
            if (STRUTS_ACTION_CONTEXT.equals(actionContextClass)) {
                Object obj = getParameters.invoke(Class.forName(this.actionContextClass).cast(context));
                Method toMapMethod = Class.forName(STRUTS_HTTP_PARAMETERS, false, classLoader)
                        .getMethod("toMap");
                return (Map) toMapMethod.invoke(obj);
            } else {
                return (Map) getParameters.invoke(Class.forName(this.actionContextClass).cast(context));
            }
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext parameter", e);
        }
    }

    @Override
    public void setSession(Map session) {
        try {
            setSession.invoke(Class.forName(this.actionContextClass).cast(context), session);
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext session", e);
        }
    }

    @Override
    public Map getSession() {
        try {
            return (Map) getSession.invoke(Class.forName(this.actionContextClass).cast(context));
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext", e);
        }
    }


    @Override
    public Object get(Object key) {
        try {
            return get.invoke(Class.forName(this.actionContextClass).cast(context), key);
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext value for given key", e);
        }
    }

    @Override
    public void put(Object key, Object value) {
        try {
            put.invoke(Class.forName(this.actionContextClass).cast(context), key, value);
        } catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ActionContext key and value", e);
        }
    }

    private Method getACStruts2Method(String methodName, ClassLoader classLoader, Class<?>... parameterTypes) throws ReflectiveOperationException {
        return Class.forName(this.actionContextClass, false, classLoader)
                .getMethod(methodName, parameterTypes);
    }
}
