/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast;

import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.cluster.hazelcast.HazelcastUtils;
import com.atlassian.fugue.Maybe;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.hazelcast.core.Member;
import java.net.InetSocketAddress;
import javax.annotation.Nonnull;

public class HazelcastClusterNodeInformation
implements ClusterNodeInformation {
    private static final long serialVersionUID = 7196398488574659353L;
    private final Member member;
    private final Supplier<String> nodeIdentifierRef;

    HazelcastClusterNodeInformation(Member member) {
        this.member = (Member)Preconditions.checkNotNull((Object)member);
        this.nodeIdentifierRef = Suppliers.memoize(() -> HazelcastUtils.getMemberId(member));
    }

    @Deprecated
    public int getId() {
        return HazelcastClusterNodeInformation.generateId(this.member);
    }

    @Deprecated
    public String getDescription() {
        return "[uuid: " + this.member.getUuid() + ", id = " + this.getId() + ", listening: " + this.getLocalSocketAddress() + "]";
    }

    public InetSocketAddress getLocalSocketAddress() {
        return this.member.getSocketAddress();
    }

    public String getAnonymizedNodeIdentifier() {
        return (String)this.nodeIdentifierRef.get();
    }

    @Nonnull
    public Maybe<String> getHumanReadableNodeName() {
        return HazelcastUtils.getConfiguredMemberName(this.member);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HazelcastClusterNodeInformation that = (HazelcastClusterNodeInformation)obj;
        return Objects.equal((Object)this.member, (Object)that.member);
    }

    @Deprecated
    static int generateId(Member mem) {
        return mem.getUuid().hashCode();
    }

    public String toString() {
        return this.member.toString();
    }
}

