/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.ClusterCacheCompactor;
import com.atlassian.confluence.cache.hazelcast.HazelcastHelper;
import com.atlassian.confluence.impl.cache.CacheCompactorSupport;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastCacheCompactor
extends CacheCompactorSupport
implements ClusterCacheCompactor {
    private static final Logger log = LoggerFactory.getLogger(HazelcastCacheCompactor.class);
    private final CacheManager cacheManager;
    private final HazelcastHelper hazelcastHelper;

    public HazelcastCacheCompactor(CacheManager cacheManager, HazelcastHelper hazelcastHelper) {
        this.cacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManager);
        this.hazelcastHelper = (HazelcastHelper)Preconditions.checkNotNull((Object)hazelcastHelper);
    }

    public void compact() {
        log.debug("Starting cache compaction");
        this.cacheManager.getManagedCaches().stream().filter(cache -> !cache.isLocal() && cache.isFlushable()).forEach(cache -> {
            long ownedEntries = this.hazelcastHelper.getHazelcastMapForCache(cache.getName()).getLocalMapStats().getOwnedEntryCount();
            Integer maxEntries = cache.currentMaxEntries();
            if (maxEntries != null && ownedEntries > (long)(2 * maxEntries)) {
                log.warn("Cache {} has overflown 2x its max size ({}/{}) and will be compacted", new Object[]{cache.getName(), ownedEntries, maxEntries});
                cache.clear();
            }
        });
        log.debug("Finished cache compaction");
    }
}

