/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.confluence.cache.CacheStatistics;
import com.atlassian.confluence.cache.CacheStatisticsCapability;
import com.atlassian.confluence.cache.CacheStatisticsManager;
import com.atlassian.confluence.cache.ehcache.EhCacheManagementConfig;
import com.atlassian.confluence.cache.ehcache.EhCacheStatistics;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.dom4j.DocumentException;

public class EhCacheStatisticsManager
implements CacheStatisticsManager {
    private final I18NBeanFactory i18NBeanFactory;
    private final CacheManager cacheManager;
    private final EhCacheManagementConfig managementConfig;
    private final FormatSettingsManager formatSettingsManager;
    private static final Comparator<CacheStatistics> CACHE_NICE_NAME_COMPARATOR = new Comparator<CacheStatistics>(){

        @Override
        public int compare(CacheStatistics o1, CacheStatistics o2) {
            String name1 = o1.getNiceName() != null ? o1.getNiceName() : o1.getName();
            String name2 = o2.getNiceName() != null ? o2.getNiceName() : o2.getName();
            return name1.compareTo(name2);
        }
    };

    public EhCacheStatisticsManager(I18NBeanFactory i18NBeanFactory, CacheManager ehCacheManager, EhCacheManagementConfig managementConfig, FormatSettingsManager formatSettingsManager) throws DocumentException {
        this.i18NBeanFactory = i18NBeanFactory;
        this.cacheManager = ehCacheManager;
        this.managementConfig = managementConfig;
        this.formatSettingsManager = formatSettingsManager;
    }

    public List<CacheStatistics> getLocalCacheStatistics() {
        ArrayList cacheStatistics = Lists.newArrayList();
        I18NBean i18nBean = this.i18NBeanFactory.getI18NBean();
        for (String cacheName : this.cacheManager.getCacheNames()) {
            cacheStatistics.add(new EhCacheStatistics(this.cacheManager.getEhcache(cacheName), i18nBean, this.managementConfig, this.formatSettingsManager));
        }
        Collections.sort(cacheStatistics, CACHE_NICE_NAME_COMPARATOR);
        return cacheStatistics;
    }

    public CacheStatistics getLocalCacheStatistics(String cacheName) {
        Ehcache ehcache = this.cacheManager.getEhcache(cacheName);
        if (ehcache != null) {
            return new EhCacheStatistics(ehcache, this.i18NBeanFactory.getI18NBean(), this.managementConfig, this.formatSettingsManager);
        }
        return null;
    }

    public Set<CacheStatisticsCapability> getCapabilities() {
        return Collections.singleton(CacheStatisticsCapability.CACHE_MISSES);
    }
}

