/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.ehcache.ConfluenceEhCache;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheManager
implements CacheManager {
    private static final Logger startupLog = LoggerFactory.getLogger((String)"com.atlassian.confluence.lifecycle");
    private static final String EHCACHE_CONFIG_PATH = "ehcache.xml";
    private final net.sf.ehcache.CacheManager delegate;
    private final List<String> nonFlushableCaches;
    private final ConcurrentMap<String, ReentrantLock> cacheCreateLocks = new ConcurrentHashMap<String, ReentrantLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EhCacheManager(List<String> nonFlushableCaches) {
        startupLog.info("Loading EhCache cache manager");
        this.nonFlushableCaches = nonFlushableCaches;
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtils.getResourceAsStream((String)EHCACHE_CONFIG_PATH, this.getClass());
            this.delegate = net.sf.ehcache.CacheManager.create((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void flushCaches() {
        for (String cacheName : this.getDelegateEhCacheManager().getCacheNames()) {
            if (this.nonFlushableCaches.contains(cacheName)) continue;
            this.getDelegateEhCacheManager().getCache(cacheName).removeAll();
        }
    }

    net.sf.ehcache.CacheManager getDelegateEhCacheManager() {
        return this.delegate;
    }

    public Collection<ConfluenceEhCache> getCaches() {
        ArrayList ret = Lists.newArrayList();
        for (String cacheName : this.getDelegateEhCacheManager().getCacheNames()) {
            ret.add(this.getCache(cacheName));
        }
        return ret;
    }

    public ConfluenceEhCache getCache(String name) {
        return new ConfluenceEhCache(this.getEhCache(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ehcache getEhCache(String name) {
        Cache cache = this.getDelegateEhCacheManager().getCache(name);
        if (cache == null) {
            ReentrantLock lock = new ReentrantLock();
            ReentrantLock previousLock = this.cacheCreateLocks.putIfAbsent(name, lock);
            if (previousLock != null) {
                lock = previousLock;
            }
            try {
                lock.lock();
                cache = this.createCacheRegion(name);
            }
            finally {
                lock.unlock();
                this.cacheCreateLocks.remove(name);
            }
        }
        return cache;
    }

    private Ehcache createCacheRegion(String name) {
        if (!this.getDelegateEhCacheManager().cacheExists(name)) {
            this.getDelegateEhCacheManager().addCache(name);
        }
        return this.getDelegateEhCacheManager().getCache(name);
    }
}

