/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory.jmx;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.memory.jmx.MemoryCacheMXBean;
import com.atlassian.util.concurrent.Supplier;
import javax.annotation.Nonnull;

public class MemoryCacheMXBeanImpl
implements MemoryCacheMXBean {
    private CacheManager cacheManager;
    private String cacheName;

    public MemoryCacheMXBeanImpl(@Nonnull CacheManager cacheManager, @Nonnull String cacheName) {
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
    }

    @Override
    public long getRequestCount() {
        return this.getProperty(CacheStatisticsKey.REQUEST_COUNT, 0L);
    }

    @Override
    public long getHitCount() {
        return this.getProperty(CacheStatisticsKey.HIT_COUNT, 0L);
    }

    @Override
    public double getHitRate() {
        long requestCount = this.getRequestCount();
        return requestCount == 0L ? 1.0 : (double)this.getHitCount() / (double)requestCount;
    }

    @Override
    public long getMissCount() {
        return this.getProperty(CacheStatisticsKey.MISS_COUNT, 0L);
    }

    @Override
    public double getMissRate() {
        long requestCount = this.getRequestCount();
        return requestCount == 0L ? 0.0 : (double)this.getMissCount() / (double)requestCount;
    }

    @Override
    public long getLoadCount() {
        return this.getProperty(CacheStatisticsKey.LOAD_COUNT, 0L);
    }

    @Override
    public long getLoadSuccessCount() {
        return this.getProperty(CacheStatisticsKey.LOAD_SUCCESS_COUNT, 0L);
    }

    @Override
    public long getLoadExceptionCount() {
        return this.getProperty(CacheStatisticsKey.LOAD_EXCEPTION_COUNT, 0L);
    }

    @Override
    public double getLoadExceptionRate() {
        long loadExceptionCount;
        long loadSuccessCount = this.getLoadSuccessCount();
        long totalLoadCount = loadSuccessCount + (loadExceptionCount = this.getLoadExceptionCount());
        return totalLoadCount == 0L ? 0.0 : (double)loadExceptionCount / (double)totalLoadCount;
    }

    @Override
    public long getTotalLoadTime() {
        return this.getProperty(CacheStatisticsKey.TOTAL_LOAD_TIME, 0L);
    }

    @Override
    public double getAverageLoadPenalty() {
        long totalLoadCount = this.getLoadSuccessCount() + this.getLoadExceptionCount();
        return totalLoadCount == 0L ? 0.0 : (double)this.getTotalLoadTime() / (double)totalLoadCount;
    }

    @Override
    public long getEvictionCount() {
        return this.getProperty(CacheStatisticsKey.EVICTION_COUNT, 0L);
    }

    @Override
    public long getSize() {
        return this.getProperty(CacheStatisticsKey.SIZE, 0L);
    }

    private long getProperty(CacheStatisticsKey propertyName, long defaultValue) {
        if (this.cacheManager.getManagedCache(this.cacheName) == null || this.cacheManager.getManagedCache(this.cacheName).getStatistics().get(propertyName) == null) {
            return defaultValue;
        }
        return (Long)((Supplier)this.cacheManager.getManagedCache(this.cacheName).getStatistics().get(propertyName)).get();
    }
}

