/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.cache.impl.CachedReferenceListenerSupport;
import com.atlassian.cache.impl.DefaultCachedReferenceListenerSupport;
import com.atlassian.cache.impl.ReferenceKey;
import com.atlassian.cache.memory.DelegatingCacheStatistics;
import com.atlassian.cache.memory.ManagedCacheSupport;
import com.atlassian.instrumentation.caches.CacheCollector;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class DelegatingCachedReference<V>
extends ManagedCacheSupport
implements CachedReference<V> {
    private final LoadingCache<ReferenceKey, V> internalCache;
    private final CachedReferenceListenerSupport<V> listenerSupport;
    private final CacheCollector counter;

    private DelegatingCachedReference(LoadingCache<ReferenceKey, V> internalCache, String name, CacheSettings settings, CacheCollector collector) {
        super(name, settings);
        this.internalCache = internalCache;
        this.listenerSupport = new DefaultCachedReferenceListenerSupport();
        this.counter = collector;
    }

    static <V> DelegatingCachedReference<V> create(LoadingCache<ReferenceKey, V> internalCache, String name, CacheSettings settings, CacheCollector collector) {
        return new DelegatingCachedReference<V>(internalCache, name, settings, collector);
    }

    @Override
    public CacheCollector getCacheCollector() {
        return this.counter;
    }

    @Nonnull
    public V get() {
        try {
            Object value = this.internalCache.getIfPresent((Object)ReferenceKey.KEY);
            if (value != null) {
                if (this.isStatisticsEnabled()) {
                    this.counter.hit();
                }
                return (V)value;
            }
            return this.getUnderLock();
        }
        catch (UncheckedExecutionException e) {
            throw new CacheException(e.getCause());
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private synchronized V getUnderLock() {
        return (V)this.internalCache.getUnchecked((Object)ReferenceKey.KEY);
    }

    public synchronized void reset() {
        try {
            this.internalCache.invalidate((Object)ReferenceKey.KEY);
            if (this.isStatisticsEnabled()) {
                this.counter.remove();
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void clear() {
        this.reset();
    }

    @Override
    public void setStatistics(boolean enabled) {
        this.counter.setEnabled(enabled);
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.counter.isEnabled();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof DelegatingCachedReference) {
            DelegatingCachedReference otherDelegatingReference = (DelegatingCachedReference)other;
            if (this.internalCache.equals(otherDelegatingReference.internalCache)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }

    @Nonnull
    public SortedMap<CacheStatisticsKey, Supplier<Long>> getStatistics() {
        if (this.isStatisticsEnabled()) {
            return DelegatingCacheStatistics.toStatistics(this.counter);
        }
        return ImmutableSortedMap.of();
    }

    public void addListener(@Nonnull CachedReferenceListener<V> listener, boolean includeValues) {
        this.listenerSupport.add(listener, includeValues);
    }

    public void removeListener(@Nonnull CachedReferenceListener<V> listener) {
        this.listenerSupport.remove(listener);
    }

    protected static class DelegatingReferenceRemovalListener<V>
    implements RemovalListener<ReferenceKey, V> {
        private DelegatingCachedReference<V> cachedReference;

        protected DelegatingReferenceRemovalListener() {
        }

        protected void onSupply(V value) {
            ((DelegatingCachedReference)this.cachedReference).listenerSupport.notifySet(value);
        }

        public void onRemoval(RemovalNotification<ReferenceKey, V> notification) {
            switch (notification.getCause()) {
                case COLLECTED: 
                case EXPIRED: {
                    ((DelegatingCachedReference)this.cachedReference).listenerSupport.notifyEvict(notification.getValue());
                    break;
                }
                case EXPLICIT: {
                    ((DelegatingCachedReference)this.cachedReference).listenerSupport.notifyReset(notification.getValue());
                    break;
                }
                case REPLACED: {
                    Object value = ((DelegatingCachedReference)this.cachedReference).internalCache.getIfPresent((Object)ReferenceKey.KEY);
                    ((DelegatingCachedReference)this.cachedReference).listenerSupport.notifySet(value);
                }
            }
        }

        public void setCachedReference(DelegatingCachedReference<V> cachedReference) {
            this.cachedReference = cachedReference;
        }
    }
}

