/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.hazelcast;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.hazelcast.HazelcastCache;
import com.atlassian.cache.hazelcast.HazelcastCachedReference;
import com.atlassian.cache.hazelcast.HazelcastHybridCache;
import com.atlassian.cache.hazelcast.HazelcastHybridCachedReference;
import com.atlassian.cache.hazelcast.HazelcastMapConfigConfigurator;
import com.atlassian.cache.impl.AbstractCacheManager;
import com.atlassian.cache.impl.ReferenceKey;
import com.atlassian.cache.impl.StrongSupplier;
import com.atlassian.cache.impl.WeakSupplier;
import com.atlassian.util.concurrent.ManagedLock;
import com.google.common.base.Preconditions;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.proxy.MapProxyImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastCacheManager
extends AbstractCacheManager {
    private static final Logger log = LoggerFactory.getLogger(HazelcastCacheManager.class);
    protected static final String PREFIX = "atlassian-cache.";
    protected static final String PREFIX_CACHE = "atlassian-cache.Cache.";
    protected static final String PREFIX_CACHE_REFERENCE = "atlassian-cache.CacheReference.";
    protected static final String SETTINGS_MAP_NAME = "atlassian-cache.settings";
    private final HazelcastInstance hazelcast;
    private final CacheFactory localCacheFactory;
    private final IMap<String, CacheSettings> mapSettings;
    private final String mapSettingsListenerId;
    private final String membershipListenerId;
    private MapServiceContext mapServiceContext;

    public HazelcastCacheManager(HazelcastInstance hazelcast, CacheFactory localCacheFactory, CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        super(cacheSettingsDefaultsProvider);
        this.hazelcast = hazelcast;
        this.localCacheFactory = localCacheFactory;
        this.mapSettings = hazelcast.getMap(SETTINGS_MAP_NAME);
        this.mapSettingsListenerId = this.mapSettings.addEntryListener((EntryListener)new EntryAdapter<String, CacheSettings>(){

            public void entryAdded(EntryEvent<String, CacheSettings> event) {
                HazelcastCacheManager.this.configureMap((String)event.getKey(), (CacheSettings)event.getValue());
            }
        }, true);
        this.membershipListenerId = hazelcast.getCluster().addMembershipListener((MembershipListener)new MembershipAdapter(){

            public void memberAdded(MembershipEvent membershipEvent) {
                HazelcastCacheManager.this.maybeUpdateMapContainers();
            }
        });
    }

    protected <K, V> ManagedCache createComputingCache(final @Nonnull String name, final @Nonnull CacheSettings settings, final CacheLoader<K, V> loader) {
        this.checkSettingsAreCompatible(name, settings);
        return (ManagedCache)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock((com.atlassian.util.concurrent.Supplier)new com.atlassian.util.concurrent.Supplier<ManagedCache>(){

            public ManagedCache get() {
                if (!HazelcastCacheManager.this.caches.containsKey(name) || loader != null) {
                    HazelcastCacheManager.this.caches.put(name, new WeakSupplier((Object)((ManagedCache)HazelcastCacheManager.this.doCreateCache(name, loader, settings))));
                }
                return (ManagedCache)((com.atlassian.util.concurrent.Supplier)HazelcastCacheManager.this.caches.get(name)).get();
            }
        });
    }

    protected ManagedCache createSimpleCache(final @Nonnull String name, final @Nonnull CacheSettings settings) {
        this.checkSettingsAreCompatible(name, settings);
        ManagedCache existing = this.getManagedCache(name);
        if (existing != null) {
            return existing;
        }
        return (ManagedCache)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock((com.atlassian.util.concurrent.Supplier)new com.atlassian.util.concurrent.Supplier<ManagedCache>(){

            public ManagedCache get() {
                if (!HazelcastCacheManager.this.caches.containsKey(name)) {
                    HazelcastCacheManager.this.caches.put(name, new StrongSupplier((Object)((ManagedCache)HazelcastCacheManager.this.doCreateCache(name, null, settings))));
                }
                return (ManagedCache)((com.atlassian.util.concurrent.Supplier)HazelcastCacheManager.this.caches.get(name)).get();
            }
        });
    }

    @PreDestroy
    public void destroy() {
        this.mapSettings.removeEntryListener(this.mapSettingsListenerId);
        this.hazelcast.getCluster().removeMembershipListener(this.membershipListenerId);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(final @Nonnull String name, final @Nonnull Supplier<V> supplier, final @Nonnull CacheSettings settings) {
        this.checkSettingsAreCompatible(name, settings);
        return (CachedReference)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock(new com.atlassian.util.concurrent.Supplier<CachedReference<V>>(){

            public CachedReference<V> get() {
                HazelcastCacheManager.this.caches.put(name, new WeakSupplier((Object)((ManagedCache)HazelcastCacheManager.this.doCreateCachedReference(name, supplier, settings))));
                return (CachedReference)((com.atlassian.util.concurrent.Supplier)HazelcastCacheManager.this.caches.get(name)).get();
            }
        });
    }

    @PostConstruct
    public void init() {
        this.maybeUpdateMapContainers();
    }

    protected void checkSettingsAreCompatible(String name, CacheSettings settings) {
    }

    protected MapConfig configureMap(String mapName, CacheSettings settings) {
        Config config = this.hazelcast.getConfig();
        MapConfig mapConfig = config.findMapConfig(mapName);
        if (!mapConfig.getName().equals(mapName)) {
            mapConfig = new MapConfig(mapConfig);
            mapConfig.setName(mapName);
            mapConfig.setStatisticsEnabled(true);
            new HazelcastMapConfigConfigurator().configureMapConfig(settings, mapConfig);
            config.addMapConfig(mapConfig);
            this.mapSettings.putIfAbsent((Object)mapName, (Object)this.asSerializable(settings));
        } else {
            log.debug("Using existing cache configuration for cache {}", (Object)mapName);
        }
        this.maybeUpdateMapContainer(mapName, mapConfig);
        return mapConfig.getAsReadOnly();
    }

    protected <K, V> Cache<K, V> createDistributedCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        String mapName = PREFIX_CACHE + name;
        MapConfig config = this.configureMap(mapName, settings);
        IMap map = this.hazelcast.getMap(mapName);
        return new HazelcastCache<K, V>(name, map, config, loader, settings);
    }

    protected <V> CachedReference<V> createDistributedCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        CacheSettings overriddenSettings = ((CacheSettings)Preconditions.checkNotNull((Object)settings, (Object)"settings")).override(new CacheSettingsBuilder().flushable().maxEntries(1000).build());
        String mapName = PREFIX_CACHE_REFERENCE + name;
        MapConfig config = this.configureMap(mapName, overriddenSettings);
        IMap map = this.hazelcast.getMap(mapName);
        return new HazelcastCachedReference<V>(name, map, config, supplier, overriddenSettings);
    }

    protected <K, V> Cache<K, V> createHybridCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        String mapName = PREFIX_CACHE + name;
        MapConfig config = this.configureMap(mapName, settings);
        IMap map = this.hazelcast.getMap(mapName);
        return new HazelcastHybridCache<K, V>(name, this.localCacheFactory, map, config, loader, settings);
    }

    protected <V> CachedReference<V> createHybridCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        String mapName = PREFIX_CACHE_REFERENCE + name;
        this.configureMap(mapName, settings);
        IMap map = this.hazelcast.getMap(mapName);
        return new HazelcastHybridCachedReference<V>(name, this.localCacheFactory, (IMap<ReferenceKey, Long>)map, supplier, settings);
    }

    private CacheSettings asSerializable(CacheSettings settings) {
        if (settings instanceof Serializable) {
            return settings;
        }
        return new CacheSettingsBuilder(settings).build();
    }

    private <K, V> Cache<K, V> doCreateCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        if (settings.getLocal(false)) {
            return this.localCacheFactory.getCache(name, loader, settings);
        }
        if (settings.getReplicateViaCopy(true)) {
            return this.createDistributedCache(name, loader, settings);
        }
        return this.createHybridCache(name, loader, settings);
    }

    private <V> CachedReference<V> doCreateCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        if (settings.getLocal(false)) {
            return this.localCacheFactory.getCachedReference(name, supplier, settings);
        }
        if (settings.getReplicateViaCopy(true)) {
            return this.createDistributedCachedReference(name, supplier, settings);
        }
        return this.createHybridCachedReference(name, supplier, settings);
    }

    private MapContainer getMapContainer(String name) {
        if (this.mapServiceContext == null) {
            MapProxyImpl proxy = (MapProxyImpl)this.hazelcast.getDistributedObject("hz:impl:mapService", SETTINGS_MAP_NAME);
            this.mapServiceContext = ((MapService)proxy.getService()).getMapServiceContext();
        }
        return this.mapServiceContext.getMapContainer(name);
    }

    private void maybeUpdateMapContainer(String mapName, MapConfig config) {
        MapContainer container = this.getMapContainer(mapName);
        if (container == null || container.getMapConfig().getName().equals(config.getName())) {
            return;
        }
        container.setMapConfig(config);
        if (container.isNearCacheEnabled() != config.isNearCacheEnabled()) {
            try {
                Field f = container.getClass().getDeclaredField("nearCacheEnabled");
                f.setAccessible(true);
                f.set(container, config.isNearCacheEnabled());
            }
            catch (Exception e) {
                log.warn("Could not {} near-cache configuration for {}: {}", new Object[]{config.isNearCacheEnabled() ? "enable" : "disable", mapName, e.getMessage()});
            }
        }
    }

    private void maybeUpdateMapContainers() {
        for (Map.Entry entry : this.mapSettings.entrySet()) {
            this.configureMap((String)entry.getKey(), (CacheSettings)entry.getValue());
        }
    }
}

