package com.atlassian.cache.ehcache.wrapper;

import net.sf.ehcache.Element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WrapperUtils {

    @SuppressWarnings("unchecked")
    public static List<Object> unwrapAllKeys(final Collection<Object> objects, ValueProcessor valueProcessor) {
        final List<Object> result = new ArrayList<>(objects.size());
        for (final Object object : objects) {
            result.add(valueProcessor.unwrap(object));
        }
        return result;
    }

    public static Element unwrapElement(Element element, ValueProcessor valueProcessor) {
        return element == null ?
                null :
                new Element(
                        valueProcessor.unwrap(element.getObjectKey()),
                        valueProcessor.unwrap(element.getObjectValue()),
                        element.getVersion(),
                        element.getCreationTime(),
                        element.getLastAccessTime(),
                        element.getHitCount(),
                        element.usesCacheDefaultLifespan(),
                        element.getTimeToLive(),
                        element.getTimeToIdle(),
                        element.getLastUpdateTime());
    }
}
