package com.atlassian.cache.compat.memory;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.GuavaAwareCacheFactory;
import com.atlassian.cache.compat.GuavaCacheVersionChecker;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.cache.compat.impl.AbstractCacheFactory;



/**
 * Maintains a mapping of name -&#62; Cache and provides factory methods for creating and getting caches.
 *
 * @since v1.0
 */
public class MemoryCacheFactory extends AbstractCacheFactory
{
    private final GuavaAwareCacheFactory delegate;

    public MemoryCacheFactory() {
        delegate = GuavaCacheVersionChecker.isGuavaVersion11() ? new com.atlassian.cache.compat.guava11.memory.MemoryCacheFactory()
                                                          : new com.atlassian.cache.compat.guava10.memory.MemoryCacheFactory();
    }

    @SuppressWarnings("unchecked")
    @Override
    public <V> CachedReference<V> getCachedReference(final String name,
                                                     final Supplier<V> supplier,
                                                     final CacheSettings settings)
    {
       return delegate.getCachedReference(name, supplier, settings);
    }

    @SuppressWarnings("unchecked")
    protected Cache createSimpleCache(final String name, final CacheSettings settings)
    {
        return delegate.createSimpleCache(name, settings);
    }

    @SuppressWarnings("unchecked")
    protected <K,V> Cache createComputingCache(final String name, final CacheSettings settings, final CacheLoader<K, V> loader)
    {
        return delegate.createComputingCache(name, settings, loader);
    }
}
