package com.atlassian.cache.compat;


/**
 * Interface allowing to delegate to an implementation that is Guava specific
 *
 * @since 1.1
 */
public interface GuavaAwareCacheFactory extends CacheFactory
{

    @SuppressWarnings("unchecked")
    Cache createSimpleCache(String name, CacheSettings settings);

    @SuppressWarnings("unchecked")
    <K,V> Cache createComputingCache(String name, CacheSettings settings, CacheLoader<K, V> loader);
}
