package com.atlassian.cache.compat;

import com.atlassian.annotations.PublicApi;

/**
 * A Resettable reference.
 *
 * @since v1.0
 */
@PublicApi
public interface CachedReference<V>
{
    /**
     * Get a value from the cache.
     *
     * @return the cached value
     */
    V get();

    /**
     * Resets (clears/invalidates) this reference.
     */
    void reset();
}
