package com.atlassian.cache.impl;

import java.lang.ref.WeakReference;

import java.util.function.Supplier;

/**
 * A supplier that holds a weak reference to its referent.
 * Contrast with {@link StrongSupplier}
 *
 * @since v2.0.8
 */
public class WeakSupplier<V> extends WeakReference<V> implements Supplier<V>
{
    public WeakSupplier(final V referent)
    {
        super(referent);
    }
}
