package com.atlassian.cache.impl;

import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.fugue.Effect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEntryNotificationSupport
{
    private static final Logger log = LoggerFactory.getLogger(CacheEntryNotificationSupport.class);

    private static final CacheEntryNotificationSupport INSTANCE = new CacheEntryNotificationSupport();

    public static CacheEntryNotificationSupport getInstance()
    {
        return INSTANCE;
    }

    public <K, V> void notifyAdd(Iterable<CacheEntryListener<K, V>> listeners,
                          final CacheEntryEvent<K, V> event)
    {
        notify(listeners, new Effect<CacheEntryListener<K, V>>()
        {
            @Override
            public void apply(CacheEntryListener<K, V> listener)
            {
                listener.onAdd(event);
            }
        });
    }

    public <K, V> void notifyEvict(Iterable<CacheEntryListener<K, V>> listeners,
                            final CacheEntryEvent<K, V> event)
    {
        notify(listeners, new Effect<CacheEntryListener<K, V>>()
        {
            @Override
            public void apply(CacheEntryListener<K, V> listener)
            {
                listener.onEvict(event);
            }
        });
    }

    public <K, V> void notifyRemove(Iterable<CacheEntryListener<K, V>> listeners,
                             final CacheEntryEvent<K, V> event)
    {
        notify(listeners, new Effect<CacheEntryListener<K, V>>()
        {
            @Override
            public void apply(CacheEntryListener<K, V> listener)
            {
                listener.onRemove(event);
            }
        });
    }

    public <K, V> void notifyUpdate(Iterable<CacheEntryListener<K, V>> listeners,
                             final CacheEntryEvent<K, V> event)
    {
        notify(listeners, new Effect<CacheEntryListener<K, V>>()
        {
            @Override
            public void apply(CacheEntryListener<K, V> listener)
            {
                listener.onUpdate(event);
            }
        });
    }

    public <K, V> void notify(Iterable<CacheEntryListener<K, V>> listeners,
                       Effect<CacheEntryListener<K, V>> effect)
    {
        for(CacheEntryListener<K, V> listener : listeners)
        {
            try
            {
                effect.apply(listener);
            }
            catch (RuntimeException exc)
            {
                log.error("Exception while notifying listeners", exc);
            }
        }
    }
}
