/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.CopyFieldOperation;
import com.atlassian.braid.document.FieldOperation;
import com.atlassian.braid.document.MappingContext;
import com.atlassian.braid.document.PutFieldOperation;
import com.atlassian.braid.document.SelectionSetMappingResult;
import com.atlassian.braid.document.TypeMapper;
import com.atlassian.braid.java.util.BraidLists;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.MapperOperations;
import com.atlassian.braid.source.OptionalHelper;
import graphql.language.Field;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class TypeMapperImpl
implements TypeMapper {
    private final Predicate<ObjectTypeDefinition> predicate;
    private final List<FieldOperation> fieldOperations;

    TypeMapperImpl(Predicate<ObjectTypeDefinition> predicate) {
        this(predicate, Collections.emptyList());
    }

    TypeMapperImpl(Predicate<ObjectTypeDefinition> predicate, List<? extends FieldOperation> fieldOperations) {
        this.predicate = Objects.requireNonNull(predicate);
        this.fieldOperations = new ArrayList<FieldOperation>((Collection)Objects.requireNonNull(fieldOperations));
    }

    @Override
    public TypeMapper copy(String key, String target) {
        return this.newTypeMapper(new CopyFieldOperation(key, target));
    }

    @Override
    public TypeMapper copyRemaining() {
        return this.newTypeMapper(new CopyFieldOperation());
    }

    @Override
    public TypeMapper put(String key, String value) {
        return this.newTypeMapper(new PutFieldOperation(key, value));
    }

    private TypeMapper newTypeMapper(FieldOperation fieldOperation) {
        return new TypeMapperImpl(this.predicate, BraidLists.concat(this.fieldOperations, fieldOperation));
    }

    @Override
    public boolean test(ObjectTypeDefinition definition) {
        return this.predicate.test(definition);
    }

    @Override
    public SelectionSetMappingResult apply(MappingContext mappingContext, SelectionSet selectionSet) {
        ArrayList outputSelections = new ArrayList();
        Map<Boolean, List<Selection>> fieldsAndNonFields = selectionSet.getSelections().stream().collect(Collectors.groupingBy(s -> s instanceof Field));
        outputSelections.addAll(fieldsAndNonFields.getOrDefault(false, Collections.emptyList()));
        List<FieldOperation.FieldOperationResult> fieldOperationResults = this.applyOperations(mappingContext, (List)BraidObjects.cast(fieldsAndNonFields.getOrDefault(true, Collections.emptyList())));
        MapperOperation mapper = fieldOperationResults.stream().peek(or -> or.getField().ifPresent(outputSelections::add)).map(FieldOperation.FieldOperationResult::getMapper).reduce((o1, o2) -> MapperOperations.composed(o1, o2)).orElse(MapperOperations.noop());
        return new SelectionSetMappingResult(new SelectionSet(outputSelections), mapper);
    }

    private List<FieldOperation.FieldOperationResult> applyOperations(MappingContext mappingContext, List<Field> fields) {
        return fields.stream().map(field -> this.applyOperation(mappingContext, (Field)field)).flatMap(OptionalHelper::toStream).collect(Collectors.toList());
    }

    private Optional<FieldOperation.FieldOperationResult> applyOperation(MappingContext mappingContext, Field field) {
        return this.fieldOperations.stream().filter(operation -> operation.test(field)).findFirst().map(operation -> operation.apply(mappingContext, field));
    }
}

