/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.Braid;
import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaBraidConfiguration;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import graphql.execution.DataFetcherResult;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoaderRegistry;

public class SchemaBraid<C extends BraidContext> {
    @Deprecated
    public Braid braid(SchemaSource<C> ... dataSources) {
        return this.braid(new TypeDefinitionRegistry(), RuntimeWiring.newRuntimeWiring(), dataSources);
    }

    @Deprecated
    public Braid braid(TypeDefinitionRegistry allTypes, RuntimeWiring.Builder wiringBuilder, SchemaSource<C> ... dataSources) {
        SchemaBraidConfiguration.SchemaBraidConfigurationBuilder configBuilder = SchemaBraidConfiguration.builder().typeDefinitionRegistry(allTypes).runtimeWiringBuilder(wiringBuilder);
        Arrays.stream(dataSources).forEach(configBuilder::schemaSource);
        return this.braid(configBuilder.build());
    }

    public Braid braid(SchemaBraidConfiguration<C> config) {
        Map<SchemaNamespace, Source<C>> dataSourceTypes = SchemaBraid.collectDataSources(config);
        TypeDefinitionRegistry braidTypeRegistry = TypeUtils.createSchemaDefinitionIfNecessary(config.getTypeDefinitionRegistry());
        ObjectTypeDefinition queryObjectTypeDefinition = TypeUtils.findQueryType(braidTypeRegistry).orElseGet(() -> TypeUtils.createDefaultQueryTypeDefinition(braidTypeRegistry));
        ObjectTypeDefinition mutationObjectTypeDefinition = TypeUtils.findMutationType(braidTypeRegistry).orElseGet(() -> TypeUtils.createDefaultMutationTypeDefinition(braidTypeRegistry));
        RuntimeWiring.Builder wiringBuilder = config.getRuntimeWiringBuilder();
        List<BatchLoader> batchLoaders = this.addDataSources(dataSourceTypes, braidTypeRegistry, wiringBuilder, queryObjectTypeDefinition, mutationObjectTypeDefinition);
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(braidTypeRegistry, wiringBuilder.build());
        return new Braid(graphQLSchema, batchLoaders);
    }

    private List<BatchLoader> addDataSources(Map<SchemaNamespace, Source<C>> dataSources, TypeDefinitionRegistry registry, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition) {
        this.addAllNonOperationTypes(dataSources, registry);
        List<BatchLoader> queryFieldsBatchLoaders = this.addSchemaSourcesTopLevelFieldsToQuery(dataSources, runtimeWiringBuilder, queryObjectTypeDefinition);
        List<BatchLoader> mutationFieldsBatchLoaders = this.addSchemaSourcesTopLevelFieldsToMutation(dataSources, runtimeWiringBuilder, mutationObjectTypeDefinition);
        List<BatchLoader> linkedTypesBatchLoaders = this.linkTypes(dataSources, runtimeWiringBuilder);
        LinkedList<BatchLoader> batchLoaders = new LinkedList<BatchLoader>();
        batchLoaders.addAll(queryFieldsBatchLoaders);
        batchLoaders.addAll(mutationFieldsBatchLoaders);
        batchLoaders.addAll(linkedTypesBatchLoaders);
        return batchLoaders;
    }

    private void addAllNonOperationTypes(Map<SchemaNamespace, Source<C>> dataSources, TypeDefinitionRegistry registry) {
        dataSources.values().forEach(source -> source.getNonOperationTypes().forEach(arg_0 -> ((TypeDefinitionRegistry)registry).add(arg_0)));
    }

    private List<BatchLoader> addSchemaSourcesTopLevelFieldsToQuery(Map<SchemaNamespace, Source<C>> dataSources, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition braidQueryType) {
        return dataSources.values().stream().map(source -> this.addSchemaSourceTopLevelFieldsToQuery((Source<C>)source, runtimeWiringBuilder, braidQueryType)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<BatchLoader> addSchemaSourcesTopLevelFieldsToMutation(Map<SchemaNamespace, Source<C>> dataSources, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition braidQueryType) {
        return dataSources.values().stream().map(source -> this.addSchemaSourceTopLevelFieldsToMutation((Source<C>)source, runtimeWiringBuilder, braidQueryType)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<BatchLoader> addSchemaSourceTopLevelFieldsToMutation(Source<C> source, RuntimeWiring.Builder wiringBuilder, ObjectTypeDefinition braidQueryType) {
        return TypeUtils.findMutationType(((Source)source).registry).map(sourceQueryType -> this.addSchemaSourceTopLevelFieldsToMutation(((Source)source).schemaSource, wiringBuilder, braidQueryType, (ObjectTypeDefinition)sourceQueryType)).orElse(Collections.emptyList());
    }

    private List<BatchLoader> addSchemaSourceTopLevelFieldsToQuery(Source<C> source, RuntimeWiring.Builder wiringBuilder, ObjectTypeDefinition braidQueryType) {
        return TypeUtils.findQueryType(((Source)source).registry).map(sourceQueryType -> this.addSchemaSourceTopLevelFieldsToQuery(((Source)source).schemaSource, wiringBuilder, braidQueryType, (ObjectTypeDefinition)sourceQueryType)).orElse(Collections.emptyList());
    }

    private List<BatchLoader> addSchemaSourceTopLevelFieldsToQuery(SchemaSource<C> schemaSource, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition queryType, ObjectTypeDefinition sourceQueryType) {
        ArrayList<BatchLoader> result = new ArrayList<BatchLoader>();
        queryType.getFieldDefinitions().addAll(sourceQueryType.getFieldDefinitions());
        runtimeWiringBuilder.type(queryType.getName(), typeRuntimeWiringBuilder -> {
            result.addAll(this.wireQueryFields((TypeRuntimeWiring.Builder)typeRuntimeWiringBuilder, schemaSource, sourceQueryType));
            return typeRuntimeWiringBuilder;
        });
        return result;
    }

    private List<BatchLoader> addSchemaSourceTopLevelFieldsToMutation(SchemaSource<C> schemaSource, RuntimeWiring.Builder runtimeWiringBuilder, ObjectTypeDefinition queryType, ObjectTypeDefinition sourceQueryType) {
        ArrayList<BatchLoader> result = new ArrayList<BatchLoader>();
        queryType.getFieldDefinitions().addAll(sourceQueryType.getFieldDefinitions());
        runtimeWiringBuilder.type(queryType.getName(), typeRuntimeWiringBuilder -> {
            result.addAll(this.wireMutationFields((TypeRuntimeWiring.Builder)typeRuntimeWiringBuilder, schemaSource, sourceQueryType));
            return typeRuntimeWiringBuilder;
        });
        return result;
    }

    private List<BatchLoader> wireMutationFields(TypeRuntimeWiring.Builder typeRuntimeWiringBuilder, SchemaSource<C> schemaSource, ObjectTypeDefinition sourceQueryType) {
        return sourceQueryType.getFieldDefinitions().stream().map(queryField -> this.wireMutationField(typeRuntimeWiringBuilder, schemaSource, (FieldDefinition)queryField)).collect(Collectors.toList());
    }

    private BatchLoader<DataFetchingEnvironment, DataFetcherResult<Map<String, Object>>> wireMutationField(TypeRuntimeWiring.Builder typeRuntimeWiringBuilder, SchemaSource<C> schemaSource, FieldDefinition mutationField) {
        BatchLoader<DataFetchingEnvironment, DataFetcherResult<Map<String, Object>>> batchLoader = this.newBatchLoader(schemaSource, null);
        typeRuntimeWiringBuilder.dataFetcher(mutationField.getName(), environment -> {
            DataLoaderRegistry registry = ((BraidContext)environment.getContext()).getDataLoaderRegistry();
            return registry.getDataLoader(batchLoader.toString()).load((Object)environment);
        });
        return batchLoader;
    }

    private List<BatchLoader> wireQueryFields(TypeRuntimeWiring.Builder typeRuntimeWiringBuilder, SchemaSource<C> schemaSource, ObjectTypeDefinition sourceQueryType) {
        return sourceQueryType.getFieldDefinitions().stream().map(queryField -> this.wireQueryField(typeRuntimeWiringBuilder, schemaSource, (FieldDefinition)queryField)).collect(Collectors.toList());
    }

    private BatchLoader<DataFetchingEnvironment, DataFetcherResult<Map<String, Object>>> wireQueryField(TypeRuntimeWiring.Builder typeRuntimeWiringBuilder, SchemaSource<C> schemaSource, FieldDefinition queryField) {
        BatchLoader<DataFetchingEnvironment, DataFetcherResult<Map<String, Object>>> batchLoader = this.newBatchLoader(schemaSource, null);
        typeRuntimeWiringBuilder.dataFetcher(queryField.getName(), environment -> {
            DataLoaderRegistry registry = ((BraidContext)environment.getContext()).getDataLoaderRegistry();
            return registry.getDataLoader(batchLoader.toString()).load((Object)environment);
        });
        return batchLoader;
    }

    private List<BatchLoader> linkTypes(Map<SchemaNamespace, Source<C>> sources, RuntimeWiring.Builder wiringBuilder) {
        ArrayList<BatchLoader> batchLoaders = new ArrayList<BatchLoader>();
        for (Source<C> source : sources.values()) {
            TypeDefinitionRegistry typeRegistry = ((Source)source).registry;
            HashMap dsTypes = new HashMap(typeRegistry.types());
            for (Link link : ((Source)source).schemaSource.getLinks()) {
                ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)dsTypes.get(link.getSourceType());
                this.validateSourceFromFieldExists(link, typeDefinition);
                Optional<FieldDefinition> sourceField = typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceField())).findFirst();
                Source<C> targetSource = sources.get(link.getTargetNamespace());
                if (!((Source)targetSource).registry.getType(link.getTargetType()).isPresent()) {
                    throw new IllegalArgumentException("Can't find target type: " + link.getTargetType());
                }
                TypeName targetType = new TypeName(link.getTargetType());
                if (!sourceField.isPresent()) {
                    FieldDefinition field = new FieldDefinition(link.getSourceField(), (Type)targetType);
                    typeDefinition.getFieldDefinitions().add(field);
                } else {
                    sourceField.get().setType((Type)targetType);
                }
                BatchLoader<DataFetchingEnvironment, DataFetcherResult<Map<String, Object>>> batchLoader = this.newBatchLoader(((Source)targetSource).schemaSource, link);
                batchLoaders.add(batchLoader);
                wiringBuilder.type(link.getSourceType(), typeWiring -> typeWiring.dataFetcher(link.getSourceField(), environment -> {
                    DataLoaderRegistry registry = ((BraidContext)environment.getContext()).getDataLoaderRegistry();
                    return registry.getDataLoader(batchLoader.toString()).load((Object)environment);
                }));
            }
        }
        return batchLoaders;
    }

    private BatchLoader<DataFetchingEnvironment, DataFetcherResult<Map<String, Object>>> newBatchLoader(SchemaSource<C> schemaSource, Link link) {
        return schemaSource.newBatchLoader(schemaSource, link);
    }

    private void validateSourceFromFieldExists(Link link, ObjectTypeDefinition typeDefinition) {
        typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceFromField())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source from field: %s", link.getSourceFromField())));
    }

    private static <C extends BraidContext> Map<SchemaNamespace, Source<C>> collectDataSources(SchemaBraidConfiguration<C> config) {
        return config.getSchemaSources().stream().collect(Collectors.toMap(SchemaSource::getNamespace, x$0 -> new Source((SchemaSource)x$0)));
    }

    private static final class Source<C extends BraidContext> {
        private final SchemaSource<C> schemaSource;
        private final TypeDefinitionRegistry registry;
        private final Collection<? extends TypeDefinition> operationTypes;

        private Source(SchemaSource<C> schemaSource) {
            this.schemaSource = Objects.requireNonNull(schemaSource);
            this.registry = schemaSource.getSchema();
            this.operationTypes = TypeUtils.findOperationTypes(this.registry);
        }

        Collection<? extends TypeDefinition> getNonOperationTypes() {
            return this.registry.types().values().stream().filter(this::isNotOperationType).collect(Collectors.toList());
        }

        boolean isNotOperationType(TypeDefinition typeDefinition) {
            return !this.isOperationType(typeDefinition);
        }

        boolean isOperationType(TypeDefinition typeDefinition) {
            return this.operationTypes.contains(typeDefinition);
        }
    }
}

