/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.source.IntrospectionResultToSchema;
import com.atlassian.braid.source.MapGraphQLError;
import com.atlassian.braid.source.OptionalHelper;
import com.atlassian.braid.source.RemoteRetriever;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.language.Document;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class RemoteSchemaSource<C>
implements SchemaSource<C> {
    private final SchemaNamespace namespace;
    private final RemoteRetriever<C> remoteRetriever;
    private final List<Link> links;
    private final TypeDefinitionRegistry publicSchema;
    private final TypeDefinitionRegistry privateSchema;

    public RemoteSchemaSource(SchemaNamespace namespace, RemoteRetriever<C> remoteRetriever, List<Link> links, String ... topLevelFields) {
        this.namespace = namespace;
        this.remoteRetriever = remoteRetriever;
        this.links = links;
        try {
            SchemaParser parser = new SchemaParser();
            TypeDefinitionRegistry schema = parser.buildRegistry(this.loadSchema().get());
            TypeUtils.filterQueryType(schema, topLevelFields);
            this.publicSchema = schema;
            this.privateSchema = parser.buildRegistry(this.loadSchema().get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TypeDefinitionRegistry getSchema() {
        return this.publicSchema;
    }

    @Override
    public TypeDefinitionRegistry getPrivateSchema() {
        return this.privateSchema;
    }

    @Override
    public SchemaNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    public CompletableFuture<DataFetcherResult<Map<String, Object>>> query(ExecutionInput query, C context) {
        return this.remoteRetriever.query(query, context).thenApply(response -> {
            Map data = OptionalHelper.castNullableMap(response.get("data"), String.class, Object.class).orElse(Collections.emptyMap());
            List errorsMap = OptionalHelper.castNullableList(response.get("errors"), Map.class).orElse(Collections.emptyList());
            List errors = errorsMap.stream().map(val -> new MapGraphQLError(OptionalHelper.castNullableMap(val, String.class, Object.class).orElseThrow(IllegalArgumentException::new))).collect(Collectors.toList());
            return new DataFetcherResult(data, errors);
        });
    }

    private CompletableFuture<Document> loadSchema() {
        return this.remoteRetriever.queryIntrospectionSchema().thenApply(response -> OptionalHelper.castNullableMap(response.get("data"), String.class, Object.class).map(data -> new IntrospectionResultToSchema().createSchemaDefinition((Map<String, Object>)data)).orElseThrow(IllegalArgumentException::new));
    }
}

