/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.SchemaNamespace;
import java.util.Objects;
import java.util.Optional;

public final class Link {
    private final LinkSource source;
    private final LinkTarget target;
    private final LinkArgument argument;

    private Link(LinkSource source, LinkTarget target, LinkArgument argument) {
        this.source = Objects.requireNonNull(source);
        this.target = Objects.requireNonNull(target);
        this.argument = Objects.requireNonNull(argument);
    }

    public static LinkBuilder from(SchemaNamespace namespace, String type, String field) {
        return Link.from(namespace, type, field, field);
    }

    public static LinkBuilder from(SchemaNamespace namespace, String type, String field, String fromField) {
        return new LinkBuilder(new LinkSource(namespace, type, field, fromField));
    }

    public String getSourceType() {
        return this.source.type;
    }

    public String getSourceField() {
        return this.source.field;
    }

    public String getSourceFromField() {
        return this.source.fromField;
    }

    public SchemaNamespace getTargetNamespace() {
        return this.target.namespace;
    }

    public String getTargetType() {
        return this.target.type;
    }

    public String getTargetField() {
        return Optional.ofNullable(this.target.queryField).orElse(this.source.field);
    }

    public String getArgumentName() {
        return this.argument.name;
    }

    private static class LinkArgument {
        private final String name;

        private LinkArgument(String name) {
            this.name = Objects.requireNonNull(name);
        }
    }

    private static class LinkTarget {
        private final SchemaNamespace namespace;
        private final String type;
        private final String queryField;

        private LinkTarget(SchemaNamespace namespace, String type, String queryField) {
            this.namespace = Objects.requireNonNull(namespace);
            this.type = Objects.requireNonNull(type);
            this.queryField = queryField;
        }
    }

    private static class LinkSource {
        private final SchemaNamespace namespace;
        private final String type;
        private final String field;
        private final String fromField;

        private LinkSource(SchemaNamespace namespace, String type, String field, String fromField) {
            this.namespace = Objects.requireNonNull(namespace);
            this.type = Objects.requireNonNull(type);
            this.field = Objects.requireNonNull(field);
            this.fromField = Objects.requireNonNull(fromField);
        }
    }

    public static final class LinkBuilder {
        private LinkSource source;
        private LinkTarget target;
        private LinkArgument argument = new LinkArgument("id");

        LinkBuilder(LinkSource source) {
            this.source = Objects.requireNonNull(source);
        }

        public LinkBuilder to(SchemaNamespace namespace, String type) {
            return this.to(namespace, type, null);
        }

        public LinkBuilder to(SchemaNamespace namespace, String type, String queryField) {
            this.target = new LinkTarget(namespace, type, queryField);
            return this;
        }

        public LinkBuilder argument(String sourceName) {
            this.argument = new LinkArgument(sourceName);
            return this;
        }

        public Link build() {
            return new Link(this.source, this.target, this.argument);
        }
    }
}

