/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import java.util.Objects;
import javax.annotation.Nullable;

public class LinkArgument {
    private final String sourceName;
    private final String queryArgumentName;
    private final ArgumentSource argumentSource;
    private final String targetFieldMatchingArgument;
    private final boolean removeInputField;
    private final boolean nullable;

    private LinkArgument(String sourceName, String queryArgumentName, ArgumentSource argumentSource, @Nullable String targetFieldMatchingArgument, boolean removeInputField, boolean nullable) {
        this.sourceName = Objects.requireNonNull(sourceName, "sourceName");
        this.queryArgumentName = Objects.requireNonNull(queryArgumentName, "queryArgumentName");
        this.argumentSource = Objects.requireNonNull(argumentSource, "argumentSource");
        this.targetFieldMatchingArgument = targetFieldMatchingArgument;
        this.removeInputField = removeInputField;
        this.nullable = nullable;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getQueryArgumentName() {
        return this.queryArgumentName;
    }

    public ArgumentSource getArgumentSource() {
        return this.argumentSource;
    }

    @Nullable
    public String getTargetFieldMatchingArgument() {
        return this.targetFieldMatchingArgument;
    }

    public boolean isRemoveInputField() {
        return this.removeInputField;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String toString() {
        return "LinkArgument{sourceName='" + this.sourceName + '\'' + ", queryArgumentName='" + this.queryArgumentName + '\'' + ", argumentSource=" + (Object)((Object)this.argumentSource) + ", targetFieldMatchingArgument='" + this.targetFieldMatchingArgument + '\'' + ", removeInputField=" + this.removeInputField + ", nullable=" + this.nullable + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkArgument that = (LinkArgument)o;
        return this.removeInputField == that.removeInputField && Objects.equals(this.sourceName, that.sourceName) && Objects.equals(this.queryArgumentName, that.queryArgumentName) && this.argumentSource == that.argumentSource && this.nullable == that.nullable && Objects.equals(this.targetFieldMatchingArgument, that.targetFieldMatchingArgument);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceName, this.queryArgumentName, this.argumentSource, this.targetFieldMatchingArgument, this.removeInputField, this.nullable});
    }

    public static LinkArgumentBuilder newLinkArgument() {
        return new LinkArgumentBuilder();
    }

    public static class LinkArgumentBuilder {
        private String sourceName;
        private String queryArgumentName;
        private ArgumentSource argumentSource;
        private String targetFieldMatchingArgument;
        private boolean removeInputField;
        private boolean nullable;

        public LinkArgumentBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public LinkArgumentBuilder queryArgumentName(String queryArgumentName) {
            this.queryArgumentName = queryArgumentName;
            return this;
        }

        public LinkArgumentBuilder argumentSource(ArgumentSource argumentSource) {
            this.argumentSource = argumentSource;
            return this;
        }

        public LinkArgumentBuilder targetFieldMatchingArgument(String targetFieldMatchingArgument) {
            this.targetFieldMatchingArgument = targetFieldMatchingArgument;
            return this;
        }

        public LinkArgumentBuilder removeInputField(boolean removeInputField) {
            this.removeInputField = removeInputField;
            return this;
        }

        public LinkArgumentBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public LinkArgument build() {
            return new LinkArgument(this.sourceName, this.queryArgumentName, this.argumentSource, this.targetFieldMatchingArgument, this.removeInputField, this.nullable);
        }
    }

    public static enum ArgumentSource {
        FIELD_ARGUMENT,
        CONTEXT,
        OBJECT_FIELD;

    }
}

