/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.transformation.FieldWithCounter;
import com.atlassian.braid.transformation.QueryTransformationUtils;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TopLevelFieldTransformation
implements FieldTransformation {
    private final FieldAlias alias;

    TopLevelFieldTransformation(FieldAlias alias) {
        this.alias = alias;
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldTransformationContext context) {
        FieldWithCounter field = QueryTransformationUtils.cloneField(context, new ArrayList<Integer>(), environment);
        if (this.alias.getBraidName().equals(field.field.getName()) && !this.alias.getSourceName().equals(field.field.getName())) {
            field.field.setName(this.alias.getSourceName());
        }
        QueryTransformationUtils.addFieldToQuery(context, environment, QueryTransformationUtils.getOperationDefinition(environment), field);
        return CompletableFuture.completedFuture(Collections.singletonList(field.field));
    }
}

