/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeAlias;
import com.atlassian.braid.document.DocumentMapper;
import com.atlassian.braid.document.DocumentMapperFactory;
import com.atlassian.braid.document.DocumentMappers;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.BaseQueryExecutorSchemaSource;
import com.atlassian.braid.source.ForwardingSchemaSource;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import com.atlassian.braid.source.SchemaUtils;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class LocalQueryExecutingSchemaSource
extends ForwardingSchemaSource
implements QueryExecutorSchemaSource {
    private final BaseQueryExecutorSchemaSource delegate;
    private final Function<ExecutionInput, Object> queryExecutor;

    private LocalQueryExecutingSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry publicSchema, TypeDefinitionRegistry privateSchema, Function<ExecutionInput, Object> queryExecutor, List<Link> links, DocumentMapperFactory documentMapper, List<TypeAlias> typeAliases, List<FieldAlias> queryFieldAliases, List<FieldAlias> mutationFieldAliases) {
        this.queryExecutor = Objects.requireNonNull(queryExecutor);
        this.delegate = new BaseQueryExecutorSchemaSource<Object>(namespace, publicSchema, privateSchema, links, documentMapper, this::query, typeAliases, queryFieldAliases, mutationFieldAliases);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected SchemaSource getDelegate() {
        return this.delegate;
    }

    @Override
    public DocumentMapper getDocumentMapper() {
        return this.delegate.getDocumentMapper();
    }

    private <C> CompletableFuture<DataFetcherResult<Map<String, Object>>> query(ExecutionInput executionInput, C context) {
        Object result = this.queryExecutor.apply(this.transformExecutionInput(executionInput, context));
        if (result instanceof DataFetcherResult) {
            return CompletableFuture.completedFuture(BraidObjects.cast(result));
        }
        if (result instanceof Map) {
            return CompletableFuture.completedFuture(new DataFetcherResult(BraidObjects.cast(result), Collections.emptyList()));
        }
        CompletableFuture<DataFetcherResult<Map<String, Object>>> future = new CompletableFuture<DataFetcherResult<Map<String, Object>>>();
        future.completeExceptionally(new IllegalStateException("Unexpected result type: " + LocalQueryExecutingSchemaSource.nullSafeGetClass(result)));
        return future;
    }

    private <C> ExecutionInput transformExecutionInput(ExecutionInput executionInput, C context) {
        return executionInput.transform(builder -> builder.context(context));
    }

    private static Class<?> nullSafeGetClass(Object result) {
        return Optional.ofNullable(result).map(Object::getClass).orElse(null);
    }

    public static class Builder {
        private List<Link> links = Collections.emptyList();
        private Supplier<Reader> schemaProvider;
        private SchemaNamespace schemaNamespace;
        private DocumentMapperFactory documentMapperFactory = DocumentMappers.identity();
        private Function<ExecutionInput, Object> remoteRetriever;
        private List<FieldAlias> queryFieldAliases = Collections.emptyList();
        private List<FieldAlias> mutationFieldAliases = Collections.emptyList();
        private List<TypeAlias> typeAliases = Collections.emptyList();

        private Builder() {
        }

        public Builder schemaProvider(Supplier<Reader> schemaProvider) {
            this.schemaProvider = schemaProvider;
            return this;
        }

        public Builder queryFieldAliases(List<FieldAlias> fieldAliases) {
            this.queryFieldAliases = fieldAliases;
            return this;
        }

        public Builder mutationFieldAliases(List<FieldAlias> fieldAliases) {
            this.mutationFieldAliases = fieldAliases;
            return this;
        }

        public Builder topLevelFields(String ... topLevelFields) {
            return this.queryFieldAliases(Arrays.stream(topLevelFields).map(name -> FieldAlias.from(name, name)).collect(Collectors.toList()));
        }

        public Builder namespace(SchemaNamespace schemaNamespace) {
            this.schemaNamespace = schemaNamespace;
            return this;
        }

        public Builder links(List<Link> links) {
            this.links = links;
            return this;
        }

        public Builder documentMapperFactory(DocumentMapperFactory documentMapperFactory) {
            this.documentMapperFactory = documentMapperFactory;
            return this;
        }

        public Builder remoteRetriever(Function<ExecutionInput, Object> remoteRetriever) {
            this.remoteRetriever = remoteRetriever;
            return this;
        }

        public Builder typeAliases(List<TypeAlias> typeAliases) {
            this.typeAliases = typeAliases;
            return this;
        }

        public LocalQueryExecutingSchemaSource build() {
            return new LocalQueryExecutingSchemaSource(Objects.requireNonNull(this.schemaNamespace), SchemaUtils.loadPublicSchema(Objects.requireNonNull(this.schemaProvider), Objects.requireNonNull(this.links), (String[])this.queryFieldAliases.stream().map(FieldAlias::getSourceName).toArray(String[]::new)), SchemaUtils.loadSchema(Objects.requireNonNull(this.schemaProvider)), Objects.requireNonNull(this.remoteRetriever), Objects.requireNonNull(this.links), Objects.requireNonNull(this.documentMapperFactory), Objects.requireNonNull(this.typeAliases), Objects.requireNonNull(this.queryFieldAliases), Objects.requireNonNull(this.mutationFieldAliases));
        }
    }
}

