/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.Link;
import com.atlassian.braid.java.util.BraidOptionals;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class TypeUtils {
    public static final String QUERY_FIELD_NAME = "query";
    public static final String MUTATION_FIELD_NAME = "mutation";
    public static final String DEFAULT_QUERY_TYPE_NAME = "Query";
    public static final String DEFAULT_MUTATION_TYPE_NAME = "Mutation";

    private TypeUtils() {
    }

    static ObjectTypeDefinition createDefaultQueryTypeDefinition() {
        return new ObjectTypeDefinition(DEFAULT_QUERY_TYPE_NAME);
    }

    static ObjectTypeDefinition createDefaultMutationTypeDefinition() {
        return new ObjectTypeDefinition(DEFAULT_MUTATION_TYPE_NAME);
    }

    public static ObjectTypeDefinition addQueryTypeToSchema(TypeDefinitionRegistry typeDefinitionRegistry, ObjectTypeDefinition objectTypeDefinition) {
        TypeUtils.addObjectTypeToSchemaDefinition(typeDefinitionRegistry, QUERY_FIELD_NAME, DEFAULT_QUERY_TYPE_NAME);
        typeDefinitionRegistry.add((SDLDefinition)objectTypeDefinition);
        return objectTypeDefinition;
    }

    public static void addMutationTypeToSchema(TypeDefinitionRegistry typeDefinitionRegistry, ObjectTypeDefinition objectTypeDefinition) {
        TypeUtils.addObjectTypeToSchemaDefinition(typeDefinitionRegistry, MUTATION_FIELD_NAME, DEFAULT_MUTATION_TYPE_NAME);
        typeDefinitionRegistry.add((SDLDefinition)objectTypeDefinition);
    }

    private static void addObjectTypeToSchemaDefinition(TypeDefinitionRegistry registry, String operationFieldName, String operationTypeName) {
        ((SchemaDefinition)registry.schemaDefinition().orElseThrow(IllegalStateException::new)).getOperationTypeDefinitions().add(new OperationTypeDefinition(operationFieldName, (Type)new TypeName(operationTypeName)));
    }

    public static Optional<List<FieldDefinition>> findQueryFieldDefinitions(TypeDefinitionRegistry registry) {
        return TypeUtils.findQueryType(registry).map(ObjectTypeDefinition::getFieldDefinitions);
    }

    static Optional<ObjectTypeDefinition> findQueryType(TypeDefinitionRegistry registry) throws IllegalArgumentException {
        return BraidOptionals.firstNonEmpty(() -> TypeUtils.findOperationType(registry, TypeUtils::isQueryOperation), () -> TypeUtils.getObjectTypeDefinitionByName(registry, DEFAULT_QUERY_TYPE_NAME));
    }

    static Optional<ObjectTypeDefinition> findMutationType(TypeDefinitionRegistry registry) throws IllegalArgumentException {
        return BraidOptionals.firstNonEmpty(() -> TypeUtils.findOperationType(registry, TypeUtils::isMutationOperation), () -> TypeUtils.getObjectTypeDefinitionByName(registry, DEFAULT_MUTATION_TYPE_NAME));
    }

    private static Optional<ObjectTypeDefinition> findOperationType(TypeDefinitionRegistry registry, Predicate<OperationTypeDefinition> isQueryOperation) {
        return TypeUtils.findOperationDefinitions(registry).flatMap(definitions -> TypeUtils.findOperationDefinition(definitions, isQueryOperation)).flatMap(TypeUtils.getObjectTypeDefinition(registry));
    }

    static List<ObjectTypeDefinition> findOperationTypes(TypeDefinitionRegistry registry) {
        return TypeUtils.findOperationDefinitions(registry).map(TypeUtils.toObjectTypeDefinition(registry)).orElse(Collections.emptyList());
    }

    public static Optional<List<OperationTypeDefinition>> findOperationDefinitions(TypeDefinitionRegistry registry) {
        return registry.schemaDefinition().map(SchemaDefinition::getOperationTypeDefinitions);
    }

    private static Optional<OperationTypeDefinition> findOperationDefinition(List<OperationTypeDefinition> definitions, Predicate<OperationTypeDefinition> isOperation) {
        return definitions.stream().filter(isOperation).findFirst();
    }

    private static boolean isQueryOperation(OperationTypeDefinition operationTypeDefinition) {
        return Objects.equals(operationTypeDefinition.getName(), QUERY_FIELD_NAME);
    }

    private static boolean isMutationOperation(OperationTypeDefinition operationTypeDefinition) {
        return Objects.equals(operationTypeDefinition.getName(), MUTATION_FIELD_NAME);
    }

    public static TypeDefinitionRegistry filterQueryType(TypeDefinitionRegistry registry, List<Link> links, String ... topLevelFields) {
        Optional<ObjectTypeDefinition> queryType;
        List<String> topFields = Arrays.asList(topLevelFields);
        if (!topFields.isEmpty() && (queryType = TypeUtils.findQueryType(registry)).isPresent()) {
            ObjectTypeDefinition objectTypeDefinition = queryType.get();
            List linkReplacedSourceFromFields = links.stream().filter(link -> link.getSourceType().equals(objectTypeDefinition.getName()) && topFields.contains(link.getSourceField()) && link.isReplaceFromField()).map(Link::getSourceFromField).collect(Collectors.toList());
            objectTypeDefinition.getFieldDefinitions().removeIf(field -> !linkReplacedSourceFromFields.contains(field.getName()) && !topFields.contains(field.getName()));
        }
        return registry;
    }

    private static Function<List<OperationTypeDefinition>, List<ObjectTypeDefinition>> toObjectTypeDefinition(TypeDefinitionRegistry registry) {
        return ods -> ods.stream().map(TypeUtils.getObjectTypeDefinition(registry)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Function<OperationTypeDefinition, Optional<ObjectTypeDefinition>> getObjectTypeDefinition(TypeDefinitionRegistry registry) {
        return otd -> registry.getType(otd.getType()).map(ObjectTypeDefinition.class::cast);
    }

    private static Optional<ObjectTypeDefinition> getObjectTypeDefinitionByName(TypeDefinitionRegistry registry, String typeName) {
        return registry.getType(typeName).map(ObjectTypeDefinition.class::cast);
    }
}

