/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaSource;
import graphql.analysis.QueryTraversal;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TrimFieldsSelection {
    public static List<FragmentDefinition> trimFieldSelection(final SchemaSource schemaSource, final DataFetchingEnvironment environment, Node root) {
        final ArrayList topLevelFieldsWithLinks = new ArrayList();
        final ArrayList fieldsWithLink = new ArrayList();
        final LinkedHashMap<SelectionSet, List> fieldsToRemove = new LinkedHashMap<SelectionSet, List>();
        final LinkedHashMap<SelectionSet, List> fieldsToAdd = new LinkedHashMap<SelectionSet, List>();
        QueryVisitorStub nodeVisitor = new QueryVisitorStub(){

            public void visitField(QueryVisitorFieldEnvironment env) {
                Optional linkWithDifferentFromField;
                boolean isTopLevelField;
                GraphQLCompositeType parentType = env.getParentType();
                Field field = env.getField();
                boolean bl = isTopLevelField = environment.getSource() == null;
                if (isTopLevelField && (linkWithDifferentFromField = TrimFieldsSelection.getLinkWithDifferentFromField(schemaSource.getLinks(), parentType.getName(), field.getName())).isPresent()) {
                    topLevelFieldsWithLinks.add(new FieldWithLink(field, (Link)linkWithDifferentFromField.get()));
                    return;
                }
                Optional link = TrimFieldsSelection.getLinkWithFieldAsSource(schemaSource.getLinks(), parentType.getName(), field.getName());
                if (link.isPresent()) {
                    fieldsWithLink.add(new FieldWithLink(field, (Link)link.get()));
                    return;
                }
                if (env.getFieldDefinition() == Introspection.TypeNameMetaFieldDef) {
                    return;
                }
                GraphQLFieldsContainer parentFieldContainer = (GraphQLFieldsContainer)env.getParentType();
                GraphQLFieldDefinition fieldDefinition = parentFieldContainer.getFieldDefinition(field.getName());
                GraphQLOutputType fieldOutputType = fieldDefinition.getType();
                this.checkSelectionSet(field.getSelectionSet(), fieldOutputType);
            }

            public void checkSelectionSet(SelectionSet selectionSet, GraphQLOutputType parentType) {
                if (selectionSet == null) {
                    return;
                }
                if (!selectionSet.getChildren().isEmpty()) {
                    for (Node child : selectionSet.getChildren()) {
                        Optional linkWithDifferentFromField;
                        if (!(child instanceof Field) || !(linkWithDifferentFromField = TrimFieldsSelection.getLinkWithDifferentFromField(schemaSource.getLinks(), parentType.getName(), ((Field)child).getName())).isPresent()) continue;
                        this.removeSourceFieldIfDifferentThanFromField(selectionSet, (Link)linkWithDifferentFromField.get());
                        this.addFromFieldToQueryIfMissing(selectionSet, (Link)linkWithDifferentFromField.get());
                    }
                }
            }

            private void addFromFieldToQueryIfMissing(SelectionSet selectionSet, Link link) {
                Optional<Selection> fromField = selectionSet.getSelections().stream().filter(s -> s instanceof Field && ((Field)s).getName().equals(link.getSourceFromField())).findFirst();
                if (!fromField.isPresent()) {
                    fieldsToAdd.computeIfAbsent(selectionSet, k -> new ArrayList());
                    ((List)fieldsToAdd.get(selectionSet)).add(new Field(link.getSourceFromField()));
                }
            }

            private void removeSourceFieldIfDifferentThanFromField(SelectionSet selectionSet, Link link) {
                selectionSet.getSelections().stream().filter(s -> s instanceof Field && ((Field)s).getName().equals(link.getSourceField())).findAny().ifPresent(s -> {
                    fieldsToRemove.computeIfAbsent(selectionSet, k -> new ArrayList());
                    ((List)fieldsToRemove.get(selectionSet)).add((Field)s);
                });
            }
        };
        Map<String, FragmentDefinition> fragmentsByName = environment.getFragmentsByName().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FragmentDefinition)entry.getValue()).deepCopy()));
        QueryTraversal queryTraversal = QueryTraversal.newQueryTraversal().schema(environment.getGraphQLSchema()).root(root).rootParentType((GraphQLObjectType)environment.getParentType()).fragmentsByName(fragmentsByName).variables(environment.getExecutionContext().getVariables()).build();
        queryTraversal.visitPreOrder((QueryVisitor)nodeVisitor);
        fieldsWithLink.forEach(fieldWithLink -> fieldWithLink.field.setSelectionSet(null));
        topLevelFieldsWithLinks.forEach(fieldWithLink -> {
            fieldWithLink.field.setSelectionSet(null);
            fieldWithLink.field.setName(fieldWithLink.link.getSourceFromField());
        });
        fieldsToRemove.forEach((selectionSet, fields) -> selectionSet.getSelections().removeAll((Collection<?>)fields));
        fieldsToAdd.forEach((selectionSet, fields) -> selectionSet.getSelections().addAll(fields));
        return TrimFieldsSelection.getReferencedFragments(root, fragmentsByName);
    }

    private static List<FragmentDefinition> getReferencedFragments(Node root, final Map<String, FragmentDefinition> fragmentDefinitionMap) {
        final LinkedHashSet referencedFragments = new LinkedHashSet();
        NodeVisitorStub nodeVisitorStub = new NodeVisitorStub(){

            public TraversalControl visitFragmentSpread(FragmentSpread fragmentSpread, TraverserContext<Node> context) {
                referencedFragments.add(fragmentDefinitionMap.get(fragmentSpread.getName()));
                return TraversalControl.CONTINUE;
            }
        };
        NodeTraverser nodeTraverser = new NodeTraverser();
        nodeTraverser.preOrder((NodeVisitor)nodeVisitorStub, root);
        return new ArrayList<FragmentDefinition>(referencedFragments);
    }

    private static Optional<Link> getLinkWithDifferentFromField(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName) && l.getSourceField().equals(fieldName) && !l.getSourceFromField().equals(fieldName)).findFirst();
    }

    private static Optional<Link> getLinkWithFieldAsSource(Collection<Link> links, String typeName, String fieldName) {
        return links.stream().filter(l -> l.getSourceType().equals(typeName)).filter(l -> l.getSourceFromField().equals(fieldName)).findFirst();
    }

    private static class FieldWithLink {
        public Field field;
        public Link link;

        public FieldWithLink(Field field, Link link) {
            this.field = field;
            this.link = link;
        }
    }
}

