/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.Link;
import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class BatchLoaderUtils {
    public static List getTargetIdsFromEnvironment(Link link, DataFetchingEnvironment environment) {
        Object ids = BatchLoaderUtils.waitForMapSource(environment, link.getSourceFromField()).orElse(null);
        if (ids instanceof String || ids instanceof Number) {
            return Collections.singletonList(ids);
        }
        if (ids instanceof List) {
            return (List)ids;
        }
        if (ids == null) {
            if (environment.getFieldType() instanceof GraphQLList) {
                return Collections.emptyList();
            }
            return Collections.singletonList(null);
        }
        throw new IllegalArgumentException("Unexpected id type: " + ids);
    }

    private static Optional<Object> waitForMapSource(DataFetchingEnvironment environment, String fromField) {
        Object source = environment.getSource();
        while (!(source instanceof Map)) {
            if (source instanceof CompletableFuture) {
                try {
                    source = ((CompletableFuture)source).get();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (source instanceof DataFetcherResult) {
                source = ((DataFetcherResult)source).getData();
                continue;
            }
            if (source instanceof String || source instanceof Number || source instanceof List) {
                return Optional.of(source);
            }
            throw new IllegalArgumentException("Unexpected parent type");
        }
        return BraidMaps.get((Map)BraidObjects.cast(source), fromField);
    }
}

