/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source.yaml;

import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.source.AbstractSchemaSource;
import com.atlassian.braid.source.SchemaUtils;
import com.atlassian.braid.source.yaml.RestRemoteRetriever;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;

public final class RestRemoteSchemaSource<C>
extends AbstractSchemaSource {
    private final RestRemoteRetriever<C> remoteRetriever;
    private final Map<String, RootField> rootFields;

    public RestRemoteSchemaSource(SchemaNamespace namespace, Supplier<Reader> schemaProvider, RestRemoteRetriever<C> remoteRetriever, Map<String, RootField> rootFields, List<Link> links, String ... topLevelFields) {
        super(namespace, SchemaUtils.loadPublicSchema(schemaProvider, topLevelFields), SchemaUtils.loadSchema(schemaProvider), links);
        this.remoteRetriever = Objects.requireNonNull(remoteRetriever);
        this.rootFields = Objects.requireNonNull(rootFields);
    }

    @Override
    public BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource schemaSource, Link link) {
        return environments -> {
            ArrayList results = new ArrayList();
            for (DataFetchingEnvironment env : environments) {
                URL url;
                Function<Map<String, Object>, Map<String, Object>> mapper;
                String uri;
                if (link == null) {
                    RootField field = this.rootFields.get(env.getFieldDefinition().getName());
                    uri = RestRemoteSchemaSource.replaceParams(env.getArguments(), field.uri);
                    mapper = field.mapper;
                } else {
                    Map source = (Map)env.getSource();
                    RootField field = this.rootFields.get(link.getTargetQueryField());
                    String id = (String)source.get(link.getSourceFromField());
                    uri = RestRemoteSchemaSource.replaceParams(Collections.singletonMap(link.getArgumentName(), id), field.uri);
                    mapper = field.mapper;
                }
                try {
                    url = new URL(uri);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                results.add((CompletableFuture)((CompletableFuture)this.remoteRetriever.get(url, env.getContext()).thenApply(mapper)).thenApply(response -> new DataFetcherResult(response, Collections.emptyList())));
            }
            return this.allOf(results);
        };
    }

    public static String replaceParams(Map<String, Object> hashMap, String template) {
        return hashMap.entrySet().stream().filter(e -> e.getValue() != null).reduce(template, (s, e) -> s.replace("{" + (String)e.getKey() + "}", e.getValue().toString()), (s, s2) -> s);
    }

    public <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futuresList) {
        CompletableFuture<Void> allFuturesResult = CompletableFuture.allOf(futuresList.toArray(new CompletableFuture[0]));
        return allFuturesResult.thenApply(v -> futuresList.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static final class RootField {
        String name;
        String uri;
        Function<Map<String, Object>, Map<String, Object>> mapper;

        public RootField(String name, String uri, Function<Map<String, Object>, Map<String, Object>> mapper) {
            this.name = name;
            this.uri = uri;
            this.mapper = mapper;
        }
    }
}

