/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.Value;
import java.util.List;
import java.util.stream.Collectors;

class GraphQLSchemaTransformer {
    GraphQLSchemaTransformer() {
    }

    <T extends Node> T visit(T node) {
        Document result = null;
        if (node instanceof Document) {
            result = this.visitDocument((Document)node);
        } else if (node instanceof SchemaDefinition) {
            result = this.visitSchemaDefinition((SchemaDefinition)node);
        } else if (node instanceof OperationTypeDefinition) {
            result = this.visitOperationTypeDefinition((OperationTypeDefinition)node);
        } else if (node instanceof ObjectTypeDefinition) {
            result = this.visitObjectTypeDefinition((ObjectTypeDefinition)node);
        } else if (node instanceof FieldDefinition) {
            result = this.visitFieldDefinition((FieldDefinition)node);
        } else if (node instanceof EnumTypeDefinition) {
            result = this.visitEnumTypeDefinition((EnumTypeDefinition)node);
        } else if (node instanceof EnumValueDefinition) {
            result = this.visitEnumValueDefinition((EnumValueDefinition)node);
        } else if (node instanceof ScalarTypeDefinition) {
            result = this.visitScalarTypeDefinition((ScalarTypeDefinition)node);
        } else if (node instanceof UnionTypeDefinition) {
            result = this.visitUnionTypeDefinition((UnionTypeDefinition)node);
        } else if (node instanceof InterfaceTypeDefinition) {
            result = this.visitInterfaceTypeDefinition((InterfaceTypeDefinition)node);
        } else if (node instanceof InputObjectTypeDefinition) {
            result = this.visitInputObjectTypeDefinition((InputObjectTypeDefinition)node);
        } else if (node instanceof InputValueDefinition) {
            result = this.visitInputValueDefinition((InputValueDefinition)node);
        } else if (node instanceof Directive) {
            result = this.visitDirective((Directive)node);
        } else if (node instanceof Argument) {
            result = this.visitArgument((Argument)node);
        } else if (node instanceof Value) {
            result = this.visitValue((Value)node);
        } else if (node instanceof NonNullType) {
            result = this.visitNonNullType((NonNullType)node);
        } else if (node instanceof ListType) {
            result = this.visitListType((ListType)node);
        } else if (node instanceof TypeName) {
            result = this.visitTypeName((TypeName)node);
        } else if (node != null) {
            throw new RuntimeException("Unknown type of node " + node.getClass().getSimpleName() + " at: " + node.getSourceLocation());
        }
        return (T)result;
    }

    private InputValueDefinition visitInputValueDefinition(InputValueDefinition node) {
        return new InputValueDefinition(node.getName(), this.visitType(node.getType()), this.visitValue(node.getDefaultValue()), this.visitNodes(node.getDirectives()));
    }

    protected TypeName visitTypeName(TypeName node) {
        return node;
    }

    protected ListType visitListType(ListType node) {
        return new ListType((Type)this.visit(node));
    }

    protected NonNullType visitNonNullType(NonNullType node) {
        return new NonNullType((Type)this.visit(node));
    }

    protected ScalarTypeDefinition visitScalarTypeDefinition(ScalarTypeDefinition node) {
        return new ScalarTypeDefinition(node.getName(), this.visitNodes(node.getDirectives()));
    }

    protected Value visitValue(Value node) {
        return node;
    }

    protected Argument visitArgument(Argument node) {
        return new Argument(node.getName(), this.visit(node.getValue()));
    }

    protected Directive visitDirective(Directive node) {
        return new Directive(node.getName(), this.visitNodes(node.getArguments()));
    }

    protected InputObjectTypeDefinition visitInputObjectTypeDefinition(InputObjectTypeDefinition node) {
        return new InputObjectTypeDefinition(node.getName(), this.visitNodes(node.getDirectives()), this.visitNodes(node.getInputValueDefinitions()));
    }

    protected InterfaceTypeDefinition visitInterfaceTypeDefinition(InterfaceTypeDefinition node) {
        return new InterfaceTypeDefinition(node.getName(), this.visitNodes(node.getFieldDefinitions()), this.visitNodes(node.getDirectives()));
    }

    protected UnionTypeDefinition visitUnionTypeDefinition(UnionTypeDefinition node) {
        return new UnionTypeDefinition(node.getName(), this.visitNodes(node.getDirectives()), this.visitNodes(node.getMemberTypes()));
    }

    protected EnumValueDefinition visitEnumValueDefinition(EnumValueDefinition node) {
        return new EnumValueDefinition(node.getName(), this.visitNodes(node.getDirectives()));
    }

    protected EnumTypeDefinition visitEnumTypeDefinition(EnumTypeDefinition node) {
        return new EnumTypeDefinition(node.getName(), this.visitNodes(node.getEnumValueDefinitions()), this.visitNodes(node.getDirectives()));
    }

    protected FieldDefinition visitFieldDefinition(FieldDefinition node) {
        return new FieldDefinition(node.getName(), this.visitType(node.getType()), this.visitNodes(node.getInputValueDefinitions()), this.visitNodes(node.getDirectives()));
    }

    protected Type visitType(Type type) {
        return type;
    }

    protected ObjectTypeDefinition visitObjectTypeDefinition(ObjectTypeDefinition node) {
        return new ObjectTypeDefinition(node.getName(), this.visitNodes(node.getImplements()), this.visitNodes(node.getDirectives()), this.visitNodes(node.getFieldDefinitions()));
    }

    protected OperationTypeDefinition visitOperationTypeDefinition(OperationTypeDefinition node) {
        return new OperationTypeDefinition(node.getName(), this.visitType(node.getType()));
    }

    protected SchemaDefinition visitSchemaDefinition(SchemaDefinition node) {
        return new SchemaDefinition(this.visitNodes(node.getDirectives()), this.visitNodes(node.getOperationTypeDefinitions()));
    }

    protected Document visitDocument(Document node) {
        return new Document(node.getDefinitions().stream().map(this::visit).collect(Collectors.toList()));
    }

    protected <T extends Node> List<T> visitNodes(List<T> nodes) {
        return nodes.stream().map(this::visit).collect(Collectors.toList());
    }
}

