/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import graphql.language.Definition;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TypeUtils {
    private static final String QUERY_FIELD_NAME = "query";
    private static final String MUTATION_FIELD_NAME = "mutation";
    private static final String DEFAULT_QUERY_TYPE_NAME = "Query";
    private static final String DEFAULT_MUTATION_TYPE_NAME = "Mutation";

    static TypeDefinitionRegistry createSchemaDefinitionIfNecessary(TypeDefinitionRegistry registry) {
        if (!registry.schemaDefinition().isPresent()) {
            registry.add((Definition)new SchemaDefinition());
        }
        return registry;
    }

    static ObjectTypeDefinition createDefaultQueryTypeDefinition(TypeDefinitionRegistry registry) {
        return TypeUtils.createOperationTypeDefinition(registry, QUERY_FIELD_NAME, DEFAULT_QUERY_TYPE_NAME);
    }

    static ObjectTypeDefinition createDefaultMutationTypeDefinition(TypeDefinitionRegistry registry) {
        return TypeUtils.createOperationTypeDefinition(registry, MUTATION_FIELD_NAME, DEFAULT_MUTATION_TYPE_NAME);
    }

    private static ObjectTypeDefinition createOperationTypeDefinition(TypeDefinitionRegistry registry, String operationFieldName, String operationTypeName) {
        ((SchemaDefinition)registry.schemaDefinition().orElseThrow(IllegalStateException::new)).getOperationTypeDefinitions().add(new OperationTypeDefinition(operationFieldName, (Type)new TypeName(operationTypeName)));
        ObjectTypeDefinition mutationObjectTypeDefinition = new ObjectTypeDefinition(operationTypeName);
        registry.add((Definition)mutationObjectTypeDefinition);
        return mutationObjectTypeDefinition;
    }

    public static Optional<List<FieldDefinition>> findQueryFieldDefinitions(TypeDefinitionRegistry registry) {
        return TypeUtils.findQueryType(registry).map(ObjectTypeDefinition::getFieldDefinitions);
    }

    static Optional<ObjectTypeDefinition> findQueryType(TypeDefinitionRegistry registry) throws IllegalArgumentException {
        return TypeUtils.findOperationType(registry, TypeUtils::isQueryOperation);
    }

    static Optional<ObjectTypeDefinition> findMutationType(TypeDefinitionRegistry registry) throws IllegalArgumentException {
        return TypeUtils.findOperationType(registry, TypeUtils::isMutationOperation);
    }

    private static Optional<ObjectTypeDefinition> findOperationType(TypeDefinitionRegistry registry, Predicate<OperationTypeDefinition> isQueryOperation) {
        return TypeUtils.findOperationDefinitions(registry).flatMap(definitions -> TypeUtils.findOperationDefinition(definitions, isQueryOperation)).flatMap(TypeUtils.getObjectTypeDefinition(registry));
    }

    static List<ObjectTypeDefinition> findOperationTypes(TypeDefinitionRegistry registry) {
        return TypeUtils.findOperationDefinitions(registry).map(TypeUtils.toObjectTypeDefinition(registry)).orElse(Collections.emptyList());
    }

    public static Optional<List<OperationTypeDefinition>> findOperationDefinitions(TypeDefinitionRegistry registry) {
        return registry.schemaDefinition().map(SchemaDefinition::getOperationTypeDefinitions);
    }

    private static Optional<OperationTypeDefinition> findOperationDefinition(List<OperationTypeDefinition> definitions, Predicate<OperationTypeDefinition> isOperation) {
        return definitions.stream().filter(isOperation).findFirst();
    }

    private static boolean isQueryOperation(OperationTypeDefinition operationTypeDefinition) {
        return Objects.equals(operationTypeDefinition.getName(), QUERY_FIELD_NAME);
    }

    private static boolean isMutationOperation(OperationTypeDefinition operationTypeDefinition) {
        return Objects.equals(operationTypeDefinition.getName(), MUTATION_FIELD_NAME);
    }

    public static TypeDefinitionRegistry filterQueryType(TypeDefinitionRegistry registry, String ... topLevelFields) {
        List<String> topFields = Arrays.asList(topLevelFields);
        if (!topFields.isEmpty()) {
            TypeUtils.findQueryType(registry).map(ObjectTypeDefinition::getFieldDefinitions).ifPresent(d -> d.removeIf(field -> !topFields.contains(field.getName())));
        }
        return registry;
    }

    private static Function<List<OperationTypeDefinition>, List<ObjectTypeDefinition>> toObjectTypeDefinition(TypeDefinitionRegistry registry) {
        return ods -> ods.stream().map(TypeUtils.getObjectTypeDefinition(registry)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Function<OperationTypeDefinition, Optional<ObjectTypeDefinition>> getObjectTypeDefinition(TypeDefinitionRegistry registry) {
        return otd -> registry.getType(otd.getType()).map(ObjectTypeDefinition.class::cast);
    }
}

