/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.util;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.markup.UrlMode;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.spi.container.ContainerRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang3.StringUtils;

public abstract class RestUtils {
    public static final String CHARSET_UTF8 = ";charset=UTF-8";
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final String TEXT_HTML_UTF8 = "text/html;charset=UTF-8";
    public static final String DEFAULT_LIMIT = "25";
    public static final String DEFAULT_START = "0";
    public static final int DEFAULT_RECENT_REPOS_LIMIT = 15;
    public static final String DEFAULT_ENTITY_VERSION = "-1";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CHARSET_PREFIX = "charset=";
    private static final Pattern COMMIT_ID_PATTERN = Pattern.compile("[0-9a-f]{40}", 2);
    private static final int LIMIT = Integer.parseInt("25");
    private static final int START = Integer.parseInt("0");
    private static final String OPTION_AVATAR_SIZE = "avatarSize";
    private static final String OPTION_AVATAR_SCHEME = "avatarScheme";
    private static final String OPTION_AVATAR_URL_MODE = "avatarUrlMode";
    private static final String URL_MODE_ABSOLUTE = "absolute";

    @Nullable
    public static AvatarRequest makeAvatarRequest(@Nonnull ContainerRequest request) {
        return RestUtils.makeAvatarRequest((HttpRequestContext)request);
    }

    @Nullable
    public static AvatarRequest makeAvatarRequest(@Nonnull HttpRequestContext request) {
        MultivaluedMap parameters = Objects.requireNonNull(request, "request").getQueryParameters();
        OptionalInt maybeSize = RestUtils.maybeParseInt((MultivaluedMap<String, String>)parameters, OPTION_AVATAR_SIZE);
        if (!maybeSize.isPresent()) {
            return null;
        }
        int size = maybeSize.getAsInt();
        if (size < 1) {
            throw new BadRequestException(OPTION_AVATAR_SIZE, "\"avatarSize\" must positive; \"" + size + "\" is not valid");
        }
        String scheme = (String)parameters.getFirst((Object)OPTION_AVATAR_SCHEME);
        boolean secure = StringUtils.isEmpty((CharSequence)scheme) ? request.isSecure() : "https".equalsIgnoreCase(scheme);
        boolean isAbsolute = URL_MODE_ABSOLUTE.equalsIgnoreCase(StringUtils.stripToNull((String)((String)parameters.getFirst((Object)OPTION_AVATAR_URL_MODE))));
        return new AvatarRequest(secure, size, isAbsolute);
    }

    @Nonnull
    public static AvatarRequest makeAvatarRequest(@Nonnull RequestManager requestManager, @Nonnull Map<String, Object> options) {
        String scheme;
        RequestContext context = Objects.requireNonNull(requestManager, "requestManager").getRequestContext();
        Object avatarSize = Objects.requireNonNull(options, "options").get(OPTION_AVATAR_SIZE);
        int size = 64;
        if (avatarSize != null) {
            if (avatarSize instanceof Number) {
                size = ((Number)avatarSize).intValue();
            } else if (avatarSize instanceof String) {
                try {
                    size = Integer.parseInt((String)avatarSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        boolean secure = (scheme = (String)options.get(OPTION_AVATAR_SCHEME)) != null ? "https".equals(scheme) : context == null || context.isSecure();
        boolean isAbsolute = URL_MODE_ABSOLUTE.equalsIgnoreCase(StringUtils.stripToNull((String)Objects.toString(options.get(OPTION_AVATAR_URL_MODE), null)));
        return new AvatarRequest(secure, size, isAbsolute);
    }

    @Nonnull
    public static PageRequest makePageRequest(@Nonnull HttpRequestContext request) {
        return RestUtils.makePageRequest(request, LIMIT);
    }

    @Nonnull
    public static PageRequest makePageRequest(@Nonnull HttpRequestContext request, int defaultLimit) {
        MultivaluedMap parameters = Objects.requireNonNull(request, "request").getQueryParameters();
        int start = RestUtils.maybeParseInt((MultivaluedMap<String, String>)parameters, "start").orElse(START);
        int limit = RestUtils.maybeParseInt((MultivaluedMap<String, String>)parameters, parameters.containsKey((Object)"limit") ? "limit" : "pageSize").orElse(defaultLimit);
        return PageUtils.newRequest((int)start, (int)limit);
    }

    @Nonnull
    public static RenderContext makeRenderContext(@Nonnull HttpRequestContext request) {
        MultivaluedMap parameters = Objects.requireNonNull(request, "request").getQueryParameters();
        return new RenderContext.Builder().hardwrap(RestUtils.parseBoolean((MultivaluedMap<String, String>)parameters, "hardwrap")).htmlEscape(RestUtils.parseBoolean((MultivaluedMap<String, String>)parameters, "htmlEscape")).includeHeadingId(RestUtils.parseBoolean((MultivaluedMap<String, String>)parameters, "includeHeadingId")).urlMode(RestUtils.parseUrlMode((MultivaluedMap<String, String>)parameters)).build();
    }

    public static boolean isImmutableObjectId(@Nullable String objectId) {
        return objectId != null && COMMIT_ID_PATTERN.matcher(objectId).matches();
    }

    public static boolean isImmutableBetween(@Nullable String untilId, @Nullable String sinceId) {
        return RestUtils.isImmutableObjectId(untilId) && (sinceId == null || RestUtils.isImmutableObjectId(sinceId));
    }

    @Nonnull
    public static <T> T notFoundIfNull(@Nullable T t) throws NotFoundException {
        if (t == null) {
            throw new NotFoundException();
        }
        return t;
    }

    @Nullable
    public static <F, T> T applyOrNull(@Nullable F from, @Nonnull Function<F, T> function) {
        if (from == null) {
            return null;
        }
        return Objects.requireNonNull(function, "function").apply(from);
    }

    @Deprecated
    @Nonnull
    public static String getOrDefaultBranch(@Nonnull RefService refService, @Nonnull Repository repository, @Nullable String at) {
        return StringUtils.isBlank((CharSequence)at) ? Objects.requireNonNull(refService, "refService").getDefaultBranch(repository).getId() : at;
    }

    public static Charset getCharset(@Nonnull ContainerRequest request, @Nullable Charset defaultCharset) {
        int p;
        String contentType = StringUtils.lowerCase((String)Objects.requireNonNull(request, "request").getHeaderValue(CONTENT_TYPE));
        if (contentType != null && (p = contentType.indexOf(CHARSET_PREFIX)) != -1) {
            return RestUtils.getCharset(contentType.substring(p + CHARSET_PREFIX.length()), defaultCharset);
        }
        return defaultCharset;
    }

    @Nullable
    public static Object processEntities(@Nullable Object entity, @Nonnull Function<Object, Object> processCallback) {
        Collection entities;
        Objects.requireNonNull(processCallback, "processCallback");
        if (entity instanceof JsonStreamingOutput) {
            return RestUtils.processStreamingOutput((JsonStreamingOutput)entity, processCallback);
        }
        if ((entity = processCallback.apply(entity)) instanceof Page) {
            entities = ((Page)entity).getValues();
        } else if (entity instanceof Iterable) {
            entities = (Iterable)entity;
        } else if (entity instanceof RestMapEntity) {
            entities = ((RestMapEntity)entity).values();
        } else {
            return entity;
        }
        for (Object o : entities) {
            RestUtils.processEntities(o, processCallback);
        }
        return entity;
    }

    @Nonnull
    public static Response processAvatarResponse(@Nonnull ContainerRequest request, @Nullable CacheControl cacheControl, @Nonnull CacheableAvatarSupplier supplier) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(supplier, "supplier");
        return RestUtils.doConditionalGet((Request)request, new Date(supplier.getTimestamp()), builder -> {
            String contentType = supplier.getContentType();
            if (contentType != null) {
                builder.variant(new Variant(MediaType.valueOf((String)contentType), request.getLanguage(), null));
            }
            return builder.entity(outputStream -> {
                try (InputStream inputStream = supplier.open();){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                outputStream.flush();
            }).cacheControl(cacheControl);
        });
    }

    @Nonnull
    public static Response doConditionalGet(@Nonnull Request request, @Nonnull Date lastUpdate, @Nonnull Function<Response.ResponseBuilder, Response.ResponseBuilder> okFunction) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(lastUpdate, "lastUpdate");
        Objects.requireNonNull(okFunction, "okFunction");
        Response.ResponseBuilder rb = request.evaluatePreconditions(lastUpdate);
        if (rb == null) {
            return okFunction.apply(Response.ok().lastModified(lastUpdate)).build();
        }
        return rb.build();
    }

    private static Charset getCharset(@Nonnull String charset, @Nullable Charset defaultCharset) {
        try {
            return Charset.forName(charset);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return defaultCharset;
        }
    }

    private static OptionalInt maybeParseInt(MultivaluedMap<String, String> parameters, String key) {
        String value = (String)parameters.getFirst((Object)key);
        if (StringUtils.isBlank((CharSequence)value) || "null".equalsIgnoreCase(value) || "undefined".equalsIgnoreCase(value)) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.valueOf(value));
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(key, "\"" + value + "\" is not a valid value for \"" + key + "\"; the value should be numeric");
        }
    }

    private static Boolean parseBoolean(MultivaluedMap<String, String> parameters, String key) {
        String value = (String)parameters.getFirst((Object)key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private static UrlMode parseUrlMode(MultivaluedMap<String, String> parameters) {
        String value = (String)parameters.getFirst((Object)"urlMode");
        if (StringUtils.isBlank((CharSequence)value)) {
            return UrlMode.RELATIVE;
        }
        try {
            return UrlMode.valueOf((String)value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("urlMode", "\"" + value + "\" is not a valid value for \"urlMode\"; valid values are: " + ImmutableList.copyOf((Object[])UrlMode.values()));
        }
    }

    private static JsonStreamingOutput processStreamingOutput(final @Nonnull JsonStreamingOutput output, final @Nonnull Function<Object, Object> processCallback) {
        Objects.requireNonNull(output, "output");
        Objects.requireNonNull(processCallback, "processCallback");
        return new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                output.write(writer.transform(input -> RestUtils.processEntities(input, processCallback)));
            }
        };
    }
}

