/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.webhook;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.webhook.WebhookCreateResult;
import com.atlassian.webdriver.bitbucket.page.webhook.WebhookPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.stream.Stream;
import org.openqa.selenium.By;

public class WebhookCreatePage
extends BitbucketPage {
    @ElementBy(id="webhooks-container")
    PageElement container;
    @ElementBy(cssSelector="#webhooks-container .aui-button-primary")
    PageElement confirmButton;
    @ElementBy(cssSelector="#webhooks-container .aui-button-link")
    PageElement cancelLink;
    private final String projectKey;
    private final String repoSlug;

    public WebhookCreatePage(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public String getUrl() {
        return String.format("/plugins/servlet/webhooks/projects/%s/repos/%s/create", this.projectKey, this.repoSlug);
    }

    public void setName(String name) {
        this.type("name", name);
    }

    public void setUrl(String url) {
        this.type("url", url);
    }

    public void setSecret(String secret) {
        this.type("secret", secret);
    }

    public void checkEvent(String eventId) {
        ElementUtils.findCheckbox(this.elementFinder, By.id((String)eventId)).check();
    }

    public List<String> getFormValidationErrors() {
        return (List)Stream.concat(this.container.findAll(By.cssSelector((String)".field-group .error li")).stream(), this.container.findAll(By.cssSelector((String)".field-group p.error")).stream()).map(PageElement::getText).collect(MoreCollectors.toImmutableList());
    }

    public WebhookCreateResult clickConfirm() {
        this.confirmButton.click();
        return (WebhookCreateResult)this.pageBinder.bind(WebhookCreateResult.class, new Object[]{this.projectKey, this.repoSlug});
    }

    public WebhookPage clickCancel() {
        this.cancelLink.click();
        return (WebhookPage)this.pageBinder.bind(WebhookPage.class, new Object[]{this.projectKey, this.repoSlug});
    }

    private void type(String id, String value) {
        this.container.find(By.id((String)id)).click().clear().type(new CharSequence[]{value});
    }
}

