/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.setup;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.setup.SetupAdminUserPage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupPage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public final class SetupSettingsPage
extends SetupPage {
    @ElementBy(id="applicationTitle")
    private PageElement applicationTitleTextBox;
    @ElementBy(id="baseUrl")
    private PageElement baseUrlTextBox;
    @ElementBy(id="generate-license-button")
    private PageElement generateLicenseButton;
    @ElementBy(id="has-key")
    private PageElement hasKeyLicenceTextBox;
    @ElementBy(id="has-key-radio")
    private AuiCheckbox hasKeyRadioButton;
    @ElementBy(id="licenseHidden")
    private PageElement hideenLicenseInput;
    @ElementBy(id="license")
    private PageElement licenseTextBox;
    @ElementBy(id="no-account-button")
    private PageElement noAccountButton;
    @ElementBy(id="no-key")
    private PageElement noKeyLicenceTextBox;
    @ElementBy(id="no-key-radio")
    private AuiCheckbox noKeyRadioButton;
    @ElementBy(id="submit")
    private PageElement submitButton;

    public SetupSettingsPage clearApplicationTitle() {
        this.applicationTitleTextBox.clear();
        Poller.waitUntil((TimedQuery)this.applicationTitleTextBox.timed().getValue(), (Matcher)Matchers.isEmptyString());
        return this;
    }

    public SetupSettingsPage clearBaseUrl() {
        this.baseUrlTextBox.clear();
        Poller.waitUntil((TimedQuery)this.baseUrlTextBox.timed().getValue(), (Matcher)Matchers.isEmptyString());
        return this;
    }

    public SetupSettingsPage clearLicense() {
        this.licenseTextBox.clear();
        Poller.waitUntil((TimedQuery)this.licenseTextBox.timed().getValue(), (Matcher)Matchers.isEmptyString());
        return this;
    }

    public SetupSettingsPage clickGenerateLicense() {
        this.generateLicenseButton.click();
        return this;
    }

    public SetupSettingsPage clickHasKey() {
        Poller.waitUntilTrue((TimedQuery)new AbstractTimedCondition(5000L, 100L){

            protected Boolean currentValue() {
                SetupSettingsPage.this.hasKeyRadioButton.click();
                return SetupSettingsPage.this.hasKeyRadioButton.isSelected();
            }
        });
        return this;
    }

    public SetupAdminUserPage clickNext() {
        return (SetupAdminUserPage)this.clickNext(true);
    }

    public SetupPage clickNext(boolean successExpected) {
        this.waitForPageLoad(() -> this.submitButton.click());
        if (successExpected) {
            return (SetupPage)this.pageBinder.bind(SetupAdminUserPage.class, new Object[0]);
        }
        return (SetupPage)this.pageBinder.bind(SetupSettingsPage.class, new Object[0]);
    }

    public SetupSettingsPage clickNoAccount() {
        this.noAccountButton.click();
        return this;
    }

    public SetupSettingsPage clickNoKey() {
        Poller.waitUntilTrue((TimedQuery)new AbstractTimedCondition(5000L, 100L){

            protected Boolean currentValue() {
                SetupSettingsPage.this.noKeyRadioButton.click();
                return SetupSettingsPage.this.noKeyRadioButton.isSelected();
            }
        });
        return this;
    }

    public SetupSettingsPage enterApplicationTitle(String title) {
        this.applicationTitleTextBox.clear().type(new CharSequence[]{title});
        Poller.waitUntil((TimedQuery)this.applicationTitleTextBox.timed().getValue(), (Matcher)Matchers.equalTo((Object)title));
        return this;
    }

    public SetupSettingsPage enterBaseURL(String url) {
        this.baseUrlTextBox.clear().type(new CharSequence[]{url});
        Poller.waitUntil((TimedQuery)this.baseUrlTextBox.timed().getValue(), (Matcher)Matchers.equalTo((Object)url));
        return this;
    }

    public SetupSettingsPage enterLicense(String licenseText) {
        this.licenseTextBox.clear().type(new CharSequence[]{licenseText});
        Poller.waitUntil((TimedQuery)this.licenseTextBox.timed().getValue(), (Matcher)Matchers.equalTo((Object)licenseText));
        return this;
    }

    @Override
    public String getStepHeading() {
        return "Licensing and settings";
    }

    public boolean hasApplicationTitleWarning() {
        PageElement error = this.elementFinder.find(By.cssSelector((String)"#applicationTitle ~ .error"));
        return (Boolean)error.timed().isPresent().byDefaultTimeout() != false && (Boolean)error.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean hasBaseURLWarning() {
        PageElement error = this.elementFinder.find(By.cssSelector((String)"#baseUrl ~ .error"));
        return (Boolean)error.timed().isPresent().byDefaultTimeout() != false && (Boolean)error.timed().isVisible().byDefaultTimeout() != false;
    }

    public boolean hasLicenseWarning() {
        PageElement error = this.elementFinder.find(By.cssSelector((String)"#license ~ .error"));
        return (Boolean)error.timed().isPresent().byDefaultTimeout() != false && (Boolean)error.timed().isVisible().byDefaultTimeout() != false;
    }
}

