/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.setup;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.LocaleSelector;
import com.atlassian.webdriver.bitbucket.page.admin.AbstractDatabasePage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupPage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupSettingsPage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupTrackingPage;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;

public class SetupDatabasePage
extends AbstractDatabasePage<SetupDatabasePage>
implements SetupTrackingPage {
    @ElementBy(id="setup-progress-iframe")
    private PageElement setupProgressTrackingIframe;
    @ElementBy(id="submit")
    private PageElement nextButton;
    @ElementBy(id="internal-false")
    private AuiCheckbox externalRadioButton;
    @ElementBy(id="internal-true")
    private AuiCheckbox internalRadioButton;

    @WaitUntil
    public void ensureHeadingMatches() {
        SetupPage.isOnSetupStep(this, this.elementFinder, this.getStepHeading());
    }

    private String getStepHeading() {
        return "Welcome";
    }

    public String getUrl() {
        return "/setup";
    }

    public LocaleSelector getLocale() {
        return new LocaleSelector(this.body);
    }

    public SetupSettingsPage clickNext() {
        this.waitForPageLoad(() -> this.nextButton.click(), Poller.by((long)5L, (TimeUnit)TimeUnit.MINUTES));
        return (SetupSettingsPage)this.pageBinder.bind(SetupSettingsPage.class, new Object[0]);
    }

    public SetupDatabasePage clickExternal() {
        this.externalRadioButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"config-fields")).timed().isVisible());
        return this;
    }

    public SetupDatabasePage clickInternal() {
        this.internalRadioButton.click();
        return this;
    }

    @Override
    public boolean hasTrackingIframe() {
        return this.setupProgressTrackingIframe.isPresent();
    }

    @Override
    public String getTrackingIframeTargetUrl() {
        return this.setupProgressTrackingIframe.getAttribute("src");
    }
}

