/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class BranchTypeConfigurationField {
    @Inject
    private PageElementFinder finder;
    private final String branchTypeId;

    public BranchTypeConfigurationField(@Nonnull String branchTypeId) {
        this.branchTypeId = Objects.requireNonNull(branchTypeId, "branchTypeId");
    }

    public PageElement getPrefixField() {
        return this.getContainer().find(By.id((String)(this.branchTypeId + "-prefix")));
    }

    public AuiCheckbox getEnabledField() {
        return ElementUtils.findCheckbox((PageElementFinder)this.getContainer(), By.id((String)(this.branchTypeId + "-enabled")));
    }

    public String getPrefix() {
        return this.getPrefixField().getValue();
    }

    public TimedQuery<Boolean> isEnabled() {
        return this.getEnabledField().timed().isSelected();
    }

    public BranchTypeConfigurationField enable() {
        this.getEnabledField().check();
        Poller.waitUntilTrue(this.isEnabled());
        return this;
    }

    public BranchTypeConfigurationField disable() {
        this.getEnabledField().uncheck();
        Poller.waitUntilFalse(this.isEnabled());
        return this;
    }

    public BranchTypeConfigurationField setPrefix(String prefix) {
        this.getPrefixField().clear().type(new CharSequence[]{prefix});
        return this;
    }

    @WaitUntil
    private void mustExist() {
        Poller.waitUntilTrue((TimedQuery)this.getContainer().timed().isPresent());
    }

    private PageElement getContainer() {
        return this.finder.find(By.id((String)this.branchTypeId));
    }

    public String getError() {
        return this.getContainer().find(By.cssSelector((String)("#" + this.branchTypeId + "-prefix + .error"))).getText();
    }

    public boolean hasError() {
        return this.getContainer().find(By.cssSelector((String)("#" + this.branchTypeId + "-prefix + .error"))).isPresent();
    }
}

