/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.bitbucket.hamcrest.IsBlankString;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.AbstractBranchModelSettingsPage;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.openqa.selenium.By;

public class BranchModelProjectSettingsPage
extends AbstractBranchModelSettingsPage<BranchModelProjectSettingsPage, ProjectDevelopmentBranchConfiguration, ProjectProductionBranchConfiguration> {
    private final String projectKey;

    public BranchModelProjectSettingsPage(String projectKey) {
        this.projectKey = projectKey;
    }

    public ProjectDevelopmentBranchConfiguration getDevelopmentConfiguration() {
        return (ProjectDevelopmentBranchConfiguration)this.pageBinder.bind(ProjectDevelopmentBranchConfiguration.class, new Object[0]);
    }

    public ProjectProductionBranchConfiguration getProductionConfiguration() {
        return (ProjectProductionBranchConfiguration)this.pageBinder.bind(ProjectProductionBranchConfiguration.class, new Object[0]);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getUrl() {
        return "/plugins/servlet/branchmodel/projects/" + this.getProjectKey();
    }

    @Override
    BranchModelProjectSettingsPage rebind() {
        BranchModelProjectSettingsPage page = (BranchModelProjectSettingsPage)this.pageBinder.bind(BranchModelProjectSettingsPage.class, new Object[]{this.getProjectKey()});
        Poller.waitUntilTrue((TimedQuery)page.isHereTimed());
        return page;
    }

    public static class ProjectProductionBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractProductionBranchConfiguration<ProjectProductionBranchConfiguration> {
        @Override
        public ProjectProductionBranchConfiguration clearBranchNameField() {
            this.getBranchNameField().clear();
            Poller.waitUntil(this.getBranchName(), (Matcher)IsBlankString.blank());
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameField().timed().getValue();
        }

        private PageElement getBranchNameField() {
            return this.finder.find(By.id((String)("branch-model-" + this.type + "-field")));
        }

        @Override
        public ProjectProductionBranchConfiguration typeBranchName(String name) {
            this.clearBranchNameField();
            this.getBranchNameField().type(new CharSequence[]{name});
            Poller.waitUntil(this.getBranchName(), (Matcher)IsEqual.equalTo((Object)name));
            this.finder.find(By.tagName((String)"h2")).click();
            return this;
        }
    }

    public static class ProjectDevelopmentBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration<ProjectDevelopmentBranchConfiguration> {
        @Override
        public ProjectDevelopmentBranchConfiguration clearBranchNameField() {
            this.getBranchNameField().clear();
            Poller.waitUntil(this.getBranchName(), (Matcher)IsBlankString.blank());
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameField().timed().getValue();
        }

        private PageElement getBranchNameField() {
            return this.finder.find(By.id((String)("branch-model-" + this.type + "-field")));
        }

        @Override
        public ProjectDevelopmentBranchConfiguration typeBranchName(String name) {
            this.clearBranchNameField();
            this.getBranchNameField().type(new CharSequence[]{name});
            Poller.waitUntil(this.getBranchName(), (Matcher)IsEqual.equalTo((Object)name));
            this.finder.find(By.tagName((String)"h2")).click();
            return this;
        }
    }
}

