/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.AbstractBranchModelSettingsPage;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.openqa.selenium.By;

public abstract class AbstractBranchModelRepositorySettingsPage<T extends AbstractBranchModelRepositorySettingsPage<T>>
extends AbstractBranchModelSettingsPage<T, RepositoryDevelopmentBranchConfiguration, RepositoryProductionBranchConfiguration> {
    private final String projectKey;
    private final String slug;

    public AbstractBranchModelRepositorySettingsPage(String projectKey, String slug) {
        this.projectKey = projectKey;
        this.slug = slug;
    }

    public TimedElement getConfirmationDialog() {
        return this.getPageElementById("are-you-sure-dialog").timed();
    }

    public RepositoryDevelopmentBranchConfiguration getDevelopmentConfiguration() {
        return (RepositoryDevelopmentBranchConfiguration)this.pageBinder.bind(RepositoryDevelopmentBranchConfiguration.class, new Object[0]);
    }

    public PageElement getPageElementByCSS(String cssSelector) {
        return this.elementFinder.find(By.cssSelector((String)cssSelector));
    }

    public PageElement getPageElementById(String id) {
        return this.elementFinder.find(By.id((String)id));
    }

    public RepositoryProductionBranchConfiguration getProductionConfiguration() {
        return (RepositoryProductionBranchConfiguration)this.pageBinder.bind(RepositoryProductionBranchConfiguration.class, new Object[0]);
    }

    public String getUrl() {
        return "/plugins/servlet/branchmodel/projects/" + this.projectKey + "/repos/" + this.slug;
    }

    @Override
    protected T rebind() {
        return (T)((AbstractBranchModelRepositorySettingsPage)this.pageBinder.bind(this.getClass(), new Object[]{this.projectKey, this.slug}));
    }

    public static class RepositoryProductionBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractProductionBranchConfiguration<RepositoryProductionBranchConfiguration> {
        @Override
        public RepositoryProductionBranchConfiguration clearBranchNameField() {
            this.getBranchNameSelector().clearInput();
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameField().getSelectedValue();
        }

        private SearchableSelector getBranchNameField() {
            return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.finder.find(By.id((String)("branch-model-" + this.type))), By.id((String)("branch-model-" + this.type + "-dialog")), this.finder.find(By.id((String)("branch-model-" + this.type + "-field")))});
        }

        private SearchableSelector getBranchNameSelector() {
            return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.finder.find(By.id((String)("branch-model-" + this.type))), By.id((String)("branch-model-" + this.type + "-dialog")), this.finder.find(By.id((String)("branch-model-" + this.type + "-field")))});
        }

        @Override
        public RepositoryProductionBranchConfiguration typeBranchName(String name) {
            SearchableSelector selector = this.getBranchNameSelector();
            if (!((Boolean)selector.getDialog().isOpen().byDefaultTimeout()).booleanValue()) {
                selector.open();
            }
            selector.getDialog().selectItemByName(name);
            Poller.waitUntil(this.getBranchName(), (Matcher)StringContains.containsString((String)name));
            return this;
        }
    }

    public static class RepositoryDevelopmentBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration<RepositoryDevelopmentBranchConfiguration> {
        @Override
        public RepositoryDevelopmentBranchConfiguration clearBranchNameField() {
            this.getBranchNameSelector().clearInput();
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameSelector().getSelectedValue();
        }

        private SearchableSelector getBranchNameSelector() {
            return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.finder.find(By.id((String)("branch-model-" + this.type))), By.id((String)("branch-model-" + this.type + "-dialog")), this.finder.find(By.id((String)("branch-model-" + this.type + "-field")))});
        }

        @Override
        public RepositoryDevelopmentBranchConfiguration typeBranchName(String name) {
            SearchableSelector selector = this.getBranchNameSelector();
            if (!((Boolean)selector.getDialog().isOpen().byDefaultTimeout()).booleanValue()) {
                selector.open();
            }
            selector.getDialog().selectItemByName(name);
            Poller.waitUntil(this.getBranchName(), (Matcher)StringContains.containsString((String)name));
            return this;
        }
    }
}

