/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.reviewergroups;

import com.atlassian.bitbucket.pageobjects.element.UserMultiSelector;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class ReviewerGroupsForm
extends AbstractElementPageObject {
    private final PageElement groupName = this.find(By.cssSelector((String)"input[name='name']"));
    private final PageElement nameInputError = this.find(By.cssSelector((String)"[data-testid='name-input-error"));
    private final PageElement reviewerSelect = this.find(By.className((String)"user-multi-select"));
    private final PageElement saveButton = this.find(By.cssSelector((String)"[type=submit]"));
    private final PageElement usersInputError = this.find(By.cssSelector((String)"[data-testid='users-input-error"));

    public ReviewerGroupsForm(@Nonnull PageElement container) {
        super(container);
        Poller.waitUntilTrue((TimedQuery)container.timed().isVisible());
    }

    public String getGroupName() {
        return this.groupName.getValue();
    }

    public String getNameValidationError() {
        return this.nameInputError.getText();
    }

    public UserMultiSelector getReviewerSelector() {
        return (UserMultiSelector)this.pageBinder.bind(UserMultiSelector.class, new Object[]{this.reviewerSelect});
    }

    public String getUsersValidationError() {
        return this.usersInputError.getText();
    }

    public void save() {
        this.saveButton.click();
        Poller.waitUntilFalse((TimedQuery)this.saveButton.timed().hasAttribute("data-has-overlay", "true"));
    }

    public void removeReviewer(String reviewer) {
        UserMultiSelector reviewerSelector = this.getReviewerSelector();
        reviewerSelector.removeUser(reviewer);
    }

    public void selectReviewer(String reviewer) {
        UserMultiSelector reviewerSelector = this.getReviewerSelector();
        reviewerSelector.addUser(reviewer);
    }

    public ReviewerGroupsForm setGroupName(String name) {
        this.groupName.clear().type(new CharSequence[]{name});
        return this;
    }
}

