/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repo;

import com.atlassian.bitbucket.pageobjects.page.FileBrowserPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestOverviewPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.ProjectOverviewPage;
import com.atlassian.webdriver.bitbucket.page.UserProfilePage;
import com.atlassian.webdriver.bitbucket.page.admin.GroupEditPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public abstract class AuditPage
extends BaseSidebarPage {
    @ElementBy(cssSelector="[data-testid=audit-log-action-filter]")
    private PageElement summaryFilter;
    @ElementBy(className="audit-table")
    private PageElement auditTable;
    @ElementBy(cssSelector="[data-testid=audit-log-category-filter]")
    private PageElement categoryFilter;
    @ElementBy(cssSelector="[data-testid=audit-log-events--table] + div svg")
    private PageElement loader;
    @ElementBy(cssSelector="[data-testid=audit-log-search-box]")
    private PageElement searchBox;
    @ElementBy(xpath="//div[contains(@class,'multi-author-select__control')]/..")
    private PageElement userFilter;

    @WaitUntil
    public List<AuditRow> waitForContent() {
        return (List)Poller.waitUntil((String)"Audit table should have at least 1 row", this.getAuditRows(), (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
    }

    public AuditPage applyFilter() {
        this.elementFinder.find(By.className((String)"audit-log-apply-btn")).click();
        Poller.waitUntilFalse((TimedQuery)this.isLoaderVisible());
        return this;
    }

    public AuditPage clickMoreButton() {
        this.elementFinder.find(By.cssSelector((String)"[data-testid=show-more-filters-btn]")).click();
        return this;
    }

    public AuditPage enterTextInSearchBox(String text) {
        this.searchBox.type(new CharSequence[]{text});
        return this;
    }

    public AuditFilter<AuditPage> getSummaryFilter() {
        return (AuditFilter)this.pageBinder.bind(AuditFilter.class, new Object[]{this, this.summaryFilter});
    }

    public TimedQuery<List<AuditRow>> getAuditRows() {
        By rowSelector = By.cssSelector((String)"tr[data-testid*=audit-log-events--row]:not([data-testid*=supplementary])");
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.elementFinder.findAll(rowSelector).stream().map(e -> (AuditRow)this.pageBinder.bind(AuditRow.class, new Object[]{e, this})).collect(MoreCollectors.toImmutableList()), (TimeoutType)TimeoutType.PAGE_LOAD);
    }

    public AuditFilter<AuditPage> getCategoryFilter() {
        return (AuditFilter)this.pageBinder.bind(AuditFilter.class, new Object[]{this, this.categoryFilter});
    }

    public TimedQuery<AuditRow> getLatestRowContaining(String summary) {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ((List)this.getAuditRows().now()).stream().filter(ar -> ar.getSummary().equals(summary)).findFirst().orElse(null));
    }

    public TimedQuery<AuditRow> getLatestRowMatching(Matcher<AuditRow> auditRowMatcher) {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> ((List)this.getAuditRows().now()).stream().filter(arg_0 -> ((Matcher)auditRowMatcher).matches(arg_0)).findFirst().orElse(null));
    }

    public PageElement getNextPageButton() {
        return this.elementFinder.find(By.cssSelector((String)"button[aria-label='Next']"));
    }

    public TimedQuery<List<PageElement>> getPageSelectors() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.elementFinder.findAll(By.cssSelector((String)"button[page]")));
    }

    public PageElement getPreviousPageButton() {
        return this.elementFinder.find(By.cssSelector((String)"button[aria-label='Previous']"));
    }

    public AuditFilter<AuditPage> getUserFilter() {
        return (AuditFilter)this.pageBinder.bind(AuditFilter.class, new Object[]{this, this.userFilter});
    }

    @SafeVarargs
    public final AuditPage waitForEventsAudited(Matcher<AuditRow> ... matchers) {
        if (!((Boolean)Conditions.forMatcher(this.getAuditRows(), (Matcher)Matchers.hasItems(matchers)).byDefaultTimeout()).booleanValue()) {
            Poller.waitUntil(this.reloadAuditRows(), (Matcher)Matchers.hasItems(matchers));
        }
        return this;
    }

    public TimedCondition isLoaderVisible() {
        return Conditions.forSupplier((Timeouts)this.timeouts, () -> this.loader.isPresent(), (TimeoutType)TimeoutType.AJAX_ACTION);
    }

    private TimedQuery<List<AuditRow>> reloadAuditRows() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            this.refresh();
            return this.waitForContent();
        }, (TimeoutType)TimeoutType.SLOW_PAGE_LOAD);
    }

    public static class AuditRow
    extends AbstractElementPageObject {
        private static final String EXPAND_BUTTON_CLOSED_LABEL = "Expand more information";
        private final AuditPage auditPage;

        public AuditRow(PageElement element, AuditPage auditPage) {
            super(element);
            this.auditPage = auditPage;
        }

        public UserProfilePage clickUser() {
            String username = this.getUsername();
            this.find(By.cssSelector((String)"[data-testid=audit-log-events--cell-2]")).find(By.tagName((String)"a")).click();
            return (UserProfilePage)this.pageBinder.bind(UserProfilePage.class, new Object[]{username});
        }

        public void expand() {
            PageElement expandButton = this.find(By.cssSelector((String)"[data-testid*=toggle-expand]"));
            if (EXPAND_BUTTON_CLOSED_LABEL.equals(expandButton.getAttribute("aria-label"))) {
                expandButton.click();
            }
        }

        public List<AffectedObject> getAffectedObjects() {
            return this.container.findAll(By.cssSelector((String)".audit-log-view-affected-object-item")).stream().map(e -> (AffectedObject)this.pageBinder.bind(AffectedObject.class, new Object[]{e})).collect(Collectors.toList());
        }

        public String getCategory() {
            return this.find(By.cssSelector((String)"[data-testid=audit-log-events--cell-3]")).getText();
        }

        public PageElement getExpandRow() {
            String cssSelector = String.format("tr[data-testid=%s-supplementary]", this.container.getAttribute("data-testid"));
            return this.auditPage.elementFinder.find(By.cssSelector((String)cssSelector));
        }

        public List<AffectedObject> getMoreAffectedObjects() {
            this.expand();
            return this.getExpandRow().findAll(By.cssSelector((String)".audit-log-view-affected-object-item")).stream().map(e -> (AffectedObject)this.pageBinder.bind(AffectedObject.class, new Object[]{e})).collect(Collectors.toList());
        }

        public String getSummary() {
            return this.find(By.cssSelector((String)"[data-testid=audit-log-events--cell-4]")).getText();
        }

        public String getTimestamp() {
            return this.find(By.cssSelector((String)"[data-testid=audit-log-events--cell-1]")).getText();
        }

        public String getUsername() {
            return this.find(By.cssSelector((String)"[data-testid=audit-log-events--cell-2]")).getText();
        }
    }

    public static class AffectedObject
    extends AbstractElementPageObject {
        public AffectedObject(@Nonnull PageElement container) {
            super(container);
        }

        public String getLink() {
            return this.container.getAttribute("href");
        }

        public String getText() {
            return this.container.getText();
        }

        public GroupEditPage goToGroup() {
            this.container.click();
            return (GroupEditPage)this.pageBinder.bind(GroupEditPage.class, new Object[0]);
        }

        public ProjectOverviewPage goToProject() {
            String projectKey = this.container.getText();
            this.container.click();
            return (ProjectOverviewPage)this.pageBinder.bind(ProjectOverviewPage.class, new Object[]{projectKey});
        }

        public PullRequestOverviewPage goToPullRequest(String projectKey, String repoSlug) {
            String pullRequestId = this.container.getText().substring(3);
            ElementUtils.scrollIntoView(this.container).click();
            return (PullRequestOverviewPage)this.pageBinder.bind(PullRequestOverviewPage.class, new Object[]{projectKey, repoSlug, Integer.valueOf(pullRequestId)});
        }

        public FileBrowserPage goToRepository(String projectKey) {
            String repoSlug = this.container.getText();
            this.container.click();
            return (FileBrowserPage)this.pageBinder.bind(FileBrowserPage.class, new Object[]{projectKey, repoSlug});
        }

        public UserProfilePage goToUser() {
            String userSlug = this.container.getText();
            this.container.click();
            return (UserProfilePage)this.pageBinder.bind(UserProfilePage.class, new Object[]{userSlug});
        }
    }

    public static class AuditFilter<T extends AuditPage>
    extends AbstractElementPageObject {
        private final T auditPage;

        public AuditFilter(@Nonnull T auditPage, @Nonnull PageElement container) {
            super(container);
            this.auditPage = (AuditPage)Objects.requireNonNull(auditPage, "auditPage");
        }

        public TimedQuery<List<PageElement>> getMenuItems() {
            return Queries.forSupplier((Timeouts)this.timeouts, () -> {
                this.find(By.cssSelector((String)"[class*=-select__control]")).click();
                return this.container.findAll(By.cssSelector((String)"[class*=-select__menu-list] > div"));
            }, (TimeoutType)TimeoutType.UI_ACTION);
        }

        public TimedQuery<List<PageElement>> getSelectedItems() {
            return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.cssSelector((String)"[class*=-select__multi-value__label]")), (TimeoutType)TimeoutType.UI_ACTION);
        }

        public T selectItems(String ... items) {
            for (String item : items) {
                List menuItems = (List)Poller.waitUntil(this.getMenuItems(), (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
                menuItems.stream().filter(e -> e.getText().equalsIgnoreCase(item)).findFirst().map(PageElement::click);
            }
            Matcher[] itemMatchers = (Matcher[])Arrays.stream(items).map(PageElementMatchers::withText).toArray(Matcher[]::new);
            Poller.waitUntil(this.getSelectedItems(), (Matcher)Matchers.contains((Matcher[])itemMatchers));
            return this.auditPage;
        }

        public T click() {
            this.container.click();
            return this.auditPage;
        }
    }
}

