/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.AdminHomePage;
import java.util.Collection;

public class AuthenticationPage
extends BitbucketPage {
    @ElementBy(className="stash-authentication-form")
    private PageElement parentForm;
    @ElementBy(id="publicSignUp")
    private AuiCheckbox publicSignUp;
    @ElementBy(id="captchaOnSignUp")
    private AuiCheckbox captchaOnSignUp;
    @ElementBy(id="maxCaptchaAttempts")
    private PageElement maxCaptchaAttempts;
    @ElementBy(id="submit")
    private PageElement saveButton;
    @ElementBy(id="cancel")
    private PageElement cancelLink;

    public String getUrl() {
        return "/admin/authentication";
    }

    public boolean isPublicSignUp() {
        return this.publicSignUp.isSelected();
    }

    public boolean isCaptchaOnSignUp() {
        return this.captchaOnSignUp.isSelected();
    }

    public AuthenticationPage setPublicSignUp(boolean publicSignUp) {
        return this.setCheckbox(this.publicSignUp, publicSignUp);
    }

    public AuthenticationPage setCaptchaOnSignUp(boolean captchaOnSignUp) {
        return this.setCheckbox(this.captchaOnSignUp, captchaOnSignUp);
    }

    public String getMaxCaptchaAttempts() {
        return this.maxCaptchaAttempts.getValue();
    }

    public AuthenticationPage setMaxCaptchaAttempts(String max) {
        this.maxCaptchaAttempts.clear().type(new CharSequence[]{max});
        return this;
    }

    public boolean isCaptchaOnSignUpEnabled() {
        return this.captchaOnSignUp.isEnabled();
    }

    private AuthenticationPage setCheckbox(AuiCheckbox checkbox, boolean value) {
        if (value) {
            checkbox.select();
        } else if (checkbox.isSelected()) {
            checkbox.click();
        }
        return this;
    }

    public AuthenticationPage clickSave() {
        this.saveButton.click();
        return this;
    }

    public AdminHomePage clickCancel() {
        this.cancelLink.click();
        return (AdminHomePage)this.pageBinder.bind(AdminHomePage.class, new Object[0]);
    }

    public Collection<String> getFieldsWithErrors() {
        return this.getFieldsWithErrors(this.parentForm);
    }
}

